<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Patient Visits</h2>
                        <p class="text-gray-600 mt-1">Manage patient check-ins and visit tracking</p>
                    </div>
                    @if(auth()->user()->isFrontDesk() || auth()->user()->isDoctor() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
                        <button wire:click="openCheckInModal" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded-lg shadow-md transition-colors">
                            <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
                            </svg>
                            Check In Patient
                        </button>
                    @endif
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                <!-- Filters -->
                <div class="mb-6">
                    <div class="flex flex-col sm:flex-row gap-4">
                        <div class="flex-1">
                            <input 
                                type="text" 
                                wire:model.live.debounce.300ms="search" 
                                placeholder="Search by visit number, patient name, or patient ID..."
                                class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                            >
                        </div>
                        <div>
                            <select wire:model.live="statusFilter" class="px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                                <option value="active">Active Visits</option>
                                <option value="all">All Visits</option>
                                <option value="checked_out">Checked Out</option>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Visits Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer" wire:click="sortBy('visit_number')">
                                    Visit Number
                                    @if($sortBy === 'visit_number')
                                        @if($sortDirection === 'asc') ↑ @else ↓ @endif
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Patient
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer" wire:click="sortBy('status')">
                                    Status
                                    @if($sortBy === 'status')
                                        @if($sortDirection === 'asc') ↑ @else ↓ @endif
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer" wire:click="sortBy('checked_in_at')">
                                    Checked In
                                    @if($sortBy === 'checked_in_at')
                                        @if($sortDirection === 'asc') ↑ @else ↓ @endif
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Chief Complaint
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Checked In By
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">Actions</span>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($visits as $visit)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        {{ $visit->visit_number }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <div>
                                            <div class="font-medium">{{ $visit->patient->full_name }}</div>
                                            <div class="text-gray-500 text-xs">{{ $visit->patient->patient_id }}</div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-{{ $visit->status_color }}-100 text-{{ $visit->status_color }}-800">
                                            {{ $visit->status_label }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <div>{{ $visit->checked_in_at->format('M d, Y') }}</div>
                                        <div class="text-xs text-gray-400">{{ $visit->checked_in_at->format('h:i A') }}</div>
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-500">
                                        <div class="max-w-xs truncate">
                                            {{ $visit->chief_complaint ?? 'N/A' }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ ucwords(strtolower($visit->createdBy->name)) }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex space-x-2">
                                            <a href="{{ route('visits.show', $visit) }}" class="text-indigo-600 hover:text-indigo-900">
                                                View
                                            </a>
                                            @if($visit->isActive() && (auth()->user()->canManageBills() || auth()->user()->isDeveloper() || auth()->user()->isCmd()))
                                                <button wire:click="updateStatus({{ $visit->id }}, 'checked_out')" 
                                                        wire:confirm="Are you sure you want to check out this patient?"
                                                        class="text-green-600 hover:text-green-900">
                                                    Check Out
                                                </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                                        No visits found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    {{ $visits->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Check-In Modal -->
    @if($showCheckInModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <!-- Background overlay -->
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeCheckInModal"></div>

                <!-- Center modal -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal panel -->
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                Check In Patient & Send to Nurse
                            </h3>
                            <button wire:click="closeCheckInModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="checkIn" class="space-y-4">
                            <!-- Patient Search -->
                            <div>
                                <x-input-label for="patient_search" :value="__('Search Patient *')" />
                                <div class="relative">
                                    <input 
                                        type="text" 
                                        id="patient_search"
                                        wire:model.live.debounce.300ms="patientSearch"
                                        wire:keyup="searchPatients"
                                        placeholder="Search by name, ID, phone, or email..."
                                        class="block w-full mt-1 border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                        autocomplete="off"
                                    />
                                    @if(count($searchResults) > 0 && !$selectedPatientId)
                                        <div class="absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-auto">
                                            @foreach($searchResults as $patient)
                                                <button 
                                                    type="button"
                                                    wire:click="selectPatient({{ $patient->id }})"
                                                    class="w-full text-left px-4 py-2 hover:bg-gray-100 focus:bg-gray-100 focus:outline-none"
                                                >
                                                    <div class="font-medium">{{ $patient->full_name }}</div>
                                                    <div class="text-sm text-gray-500">{{ $patient->patient_id }} • {{ $patient->phone ?? 'N/A' }}</div>
                                                </button>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                                @if($selectedPatientId)
                                    <div class="mt-2 p-2 bg-green-50 border border-green-200 rounded">
                                        <span class="text-sm text-green-800">✓ Patient selected</span>
                                    </div>
                                @endif
                                <x-input-error :messages="$errors->get('selectedPatientId')" class="mt-1" />
                            </div>

                            <!-- Chief Complaint - For Doctors, Developers, and CMD -->
                            @if(auth()->user()->canEnterChiefComplaint())
                                <div>
                                    <x-input-label for="chief_complaint" :value="__('Chief Complaint')" />
                                    <textarea 
                                        id="chief_complaint"
                                        wire:model="chiefComplaint"
                                        rows="3"
                                        placeholder="Brief description of patient's main complaint..."
                                        class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                    ></textarea>
                                    <x-input-error :messages="$errors->get('chiefComplaint')" class="mt-1" />
                                </div>
                            @endif

                            <!-- Visit Notes -->
                            <div>
                                <x-input-label for="visit_notes" :value="__('Visit Notes (Optional)')" />
                                <textarea 
                                    id="visit_notes"
                                    wire:model="visitNotes"
                                    rows="2"
                                    placeholder="Any additional notes..."
                                    class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                ></textarea>
                                <x-input-error :messages="$errors->get('visitNotes')" class="mt-1" />
                            </div>

                            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-xs text-blue-800">
                                    <strong>Note:</strong> After check-in, the patient will be automatically sent to the nursing station for vitals recording.
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeCheckInModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="checkIn" class="text-sm">
                                    <span wire:loading.remove wire:target="checkIn">Check In & Send to Nurse</span>
                                    <span wire:loading wire:target="checkIn">Checking In...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
