<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Surgery Management</h2>
                        <p class="text-gray-600 mt-1">Manage scheduled surgeries and operations</p>
                    </div>
                    <button wire:click="openCreateModal" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
                        + Book Surgery
                    </button>
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                <!-- Search and Filters -->
                <div class="mb-6 grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                        <input type="text" wire:model.live.debounce.300ms="search" placeholder="Operation #, Patient, Procedure..." class="block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select wire:model.live="statusFilter" class="block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">All Statuses</option>
                            <option value="scheduled">Scheduled</option>
                            <option value="preparing">Preparing</option>
                            <option value="in_progress">In Progress</option>
                            <option value="completed">Completed</option>
                            <option value="cancelled">Cancelled</option>
                            <option value="postponed">Postponed</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Date Filter</label>
                        <select wire:model.live="dateFilter" class="block w-full border-gray-300 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">All Dates</option>
                            <option value="today">Today</option>
                            <option value="upcoming">Upcoming</option>
                            <option value="past">Past</option>
                        </select>
                    </div>
                    <div class="flex items-end">
                        <button wire:click="$set('search', ''); $set('statusFilter', ''); $set('dateFilter', '')" class="w-full bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium py-2 px-4 rounded">
                            Clear Filters
                        </button>
                    </div>
                </div>

                <!-- Surgeries Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Operation #</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Patient</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Procedure</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Surgeon</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Room</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Scheduled</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($operations as $operation)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $operation->operation_number }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ ucwords(strtolower($operation->patient->full_name)) }}</div>
                                        <div class="text-sm text-gray-500">{{ $operation->patient->patient_id }}</div>
                                    </td>
                                    <td class="px-6 py-4">
                                        <div class="text-sm font-medium text-gray-900">{{ $operation->procedure_name }}</div>
                                        <div class="text-sm text-gray-500">{{ $operation->surgery_type }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">{{ ucwords(strtolower($operation->surgeon->name)) }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($operation->operationRoom)
                                            <div class="text-sm text-gray-900">{{ $operation->operationRoom->room_number }}</div>
                                            <div class="text-sm text-gray-500">{{ ucwords(strtolower($operation->operationRoom->name)) }}</div>
                                        @else
                                            <span class="text-sm text-gray-400">Not assigned</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">{{ $operation->scheduled_date->format('M d, Y') }}</div>
                                        <div class="text-sm text-gray-500">{{ \Carbon\Carbon::parse($operation->scheduled_time)->format('h:i A') }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-{{ $operation->status_color }}-100 text-{{ $operation->status_color }}-800">
                                            {{ $operation->status_label }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <div class="flex space-x-2">
                                            <button wire:click="openViewModal({{ $operation->id }})" class="text-blue-600 hover:text-blue-900">View</button>
                                            <button wire:click="openEditModal({{ $operation->id }})" class="text-indigo-600 hover:text-indigo-900">Edit</button>
                                            @if($operation->canStart())
                                                <button wire:click="startOperation({{ $operation->id }})" class="text-green-600 hover:text-green-900">Start</button>
                                            @endif
                                            @if($operation->canComplete())
                                                <button wire:click="completeOperation({{ $operation->id }})" class="text-purple-600 hover:text-purple-900">Complete</button>
                                            @endif
                                            @if(in_array($operation->status, [\App\Models\Operation::STATUS_SCHEDULED, \App\Models\Operation::STATUS_PREPARING]))
                                                <button wire:click="cancelOperation({{ $operation->id }})" onclick="return confirm('Are you sure you want to cancel this operation?')" class="text-red-600 hover:text-red-900">Cancel</button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="px-6 py-4 text-center text-sm text-gray-500">
                                        No surgeries found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    {{ $operations->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Modal -->
    @if($showCreateModal || $showEditModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeModals"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-900">
                                {{ $showEditModal ? 'Edit Surgery' : 'Book Surgery' }}
                            </h3>
                            <button wire:click="closeModals" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="save" class="space-y-4">
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="patient_id" :value="__('Patient *')" />
                                    <div class="relative">
                                        <input 
                                            type="text" 
                                            id="patient_search"
                                            wire:model.live.debounce.300ms="patientSearch"
                                            wire:keyup="searchPatients"
                                            placeholder="Search by name, ID, phone, or email..."
                                            class="block w-full mt-1 border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                            autocomplete="off"
                                        />
                                        @if(count($searchResults) > 0 && !$patient_id)
                                            <div class="absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-auto">
                                                @foreach($searchResults as $patient)
                                                    <button 
                                                        type="button"
                                                        wire:click="selectPatient({{ $patient->id }})"
                                                        class="w-full text-left px-4 py-2 hover:bg-gray-100 focus:bg-gray-100 focus:outline-none"
                                                    >
                                                        <div class="font-medium">{{ $patient->full_name }}</div>
                                                        <div class="text-sm text-gray-500">{{ $patient->patient_id }} • {{ $patient->phone ?? 'N/A' }}</div>
                                                    </button>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                    @if($patient_id)
                                        <div class="mt-2 p-2 bg-green-50 border border-green-200 rounded">
                                            <span class="text-sm text-green-800">✓ Patient selected</span>
                                        </div>
                                    @endif
                                    <input type="hidden" wire:model="patient_id" />
                                    <x-input-error :messages="$errors->get('patient_id')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="surgeon_id" :value="__('Surgeon *')" />
                                    <select id="surgeon_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="surgeon_id" required>
                                        <option value="">Select Surgeon</option>
                                        @foreach($doctors as $doctor)
                                            <option value="{{ $doctor->id }}">{{ ucwords(strtolower($doctor->name)) }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('surgeon_id')" class="mt-1" />
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="surgery_type" :value="__('Surgery Type *')" />
                                    <x-text-input id="surgery_type" class="block mt-1 w-full" type="text" wire:model="surgery_type" required />
                                    <x-input-error :messages="$errors->get('surgery_type')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="procedure_name" :value="__('Procedure Name *')" />
                                    <x-text-input id="procedure_name" class="block mt-1 w-full" type="text" wire:model="procedure_name" required />
                                    <x-input-error :messages="$errors->get('procedure_name')" class="mt-1" />
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="diagnosis" :value="__('Diagnosis')" />
                                    <textarea id="diagnosis" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="diagnosis"></textarea>
                                    <x-input-error :messages="$errors->get('diagnosis')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="indication" :value="__('Indication')" />
                                    <textarea id="indication" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="indication"></textarea>
                                    <x-input-error :messages="$errors->get('indication')" class="mt-1" />
                                </div>
                            </div>

                            <div class="grid grid-cols-4 gap-4">
                                <div>
                                    <x-input-label for="scheduled_date" :value="__('Date *')" />
                                    <x-text-input id="scheduled_date" class="block mt-1 w-full" type="date" wire:model="scheduled_date" required />
                                    <x-input-error :messages="$errors->get('scheduled_date')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="scheduled_time" :value="__('Time *')" />
                                    <x-text-input id="scheduled_time" class="block mt-1 w-full" type="time" wire:model="scheduled_time" required />
                                    <x-input-error :messages="$errors->get('scheduled_time')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="estimated_duration" :value="__('Duration (min) *')" />
                                    <x-text-input id="estimated_duration" class="block mt-1 w-full" type="number" wire:model="estimated_duration" min="15" max="1440" required />
                                    <x-input-error :messages="$errors->get('estimated_duration')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="status" :value="__('Status *')" />
                                    <select id="status" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="status" required>
                                        <option value="scheduled">Scheduled</option>
                                        <option value="preparing">Preparing</option>
                                        <option value="in_progress">In Progress</option>
                                        <option value="completed">Completed</option>
                                        <option value="cancelled">Cancelled</option>
                                        <option value="postponed">Postponed</option>
                                    </select>
                                    <x-input-error :messages="$errors->get('status')" class="mt-1" />
                                </div>
                            </div>

                            <div class="grid grid-cols-3 gap-4">
                                <div>
                                    <x-input-label for="operation_room_id" :value="__('Operation Room')" />
                                    <select id="operation_room_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="operation_room_id">
                                        <option value="">Select Room</option>
                                        @foreach($operationRooms as $room)
                                            <option value="{{ $room->id }}">{{ $room->room_number }} - {{ ucwords(strtolower($room->name)) }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('operation_room_id')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="assistant_surgeon_id" :value="__('Assistant Surgeon')" />
                                    <select id="assistant_surgeon_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="assistant_surgeon_id">
                                        <option value="">Select Assistant</option>
                                        @foreach($doctors as $doctor)
                                            <option value="{{ $doctor->id }}">{{ ucwords(strtolower($doctor->name)) }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('assistant_surgeon_id')" class="mt-1" />
                                </div>
                                <div>
                                    <x-input-label for="anesthesiologist_id" :value="__('Anesthesiologist')" />
                                    <select id="anesthesiologist_id" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="anesthesiologist_id">
                                        <option value="">Select Anesthesiologist</option>
                                        @foreach($doctors as $doctor)
                                            <option value="{{ $doctor->id }}">{{ ucwords(strtolower($doctor->name)) }}</option>
                                        @endforeach
                                    </select>
                                    <x-input-error :messages="$errors->get('anesthesiologist_id')" class="mt-1" />
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="pre_operative_notes" :value="__('Pre-operative Notes')" />
                                    <textarea id="pre_operative_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="pre_operative_notes"></textarea>
                                </div>
                                <div>
                                    <x-input-label for="operative_notes" :value="__('Operative Notes')" />
                                    <textarea id="operative_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="operative_notes"></textarea>
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="post_operative_notes" :value="__('Post-operative Notes')" />
                                    <textarea id="post_operative_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="post_operative_notes"></textarea>
                                </div>
                                <div>
                                    <x-input-label for="complications" :value="__('Complications')" />
                                    <textarea id="complications" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="complications"></textarea>
                                </div>
                            </div>

                            <div>
                                <x-input-label for="notes" :value="__('Additional Notes')" />
                                <textarea id="notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="2" wire:model="notes"></textarea>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeModals" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="save" class="text-sm">
                                    <span wire:loading.remove wire:target="save">{{ $showEditModal ? 'Update' : 'Book' }} Surgery</span>
                                    <span wire:loading wire:target="save">Saving...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- View Modal -->
    @if($showViewModal && $selectedOperation)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeModals"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900">Operation Details</h3>
                                <p class="text-sm text-gray-500 mt-1">{{ $selectedOperation->operation_number }}</p>
                            </div>
                            <button wire:click="closeModals" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <div class="space-y-4">
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Patient</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ ucwords(strtolower($selectedOperation->patient->full_name)) }} ({{ $selectedOperation->patient->patient_id }})</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Status</label>
                                    <span class="mt-1 inline-block px-2 py-1 text-xs font-semibold rounded-full bg-{{ $selectedOperation->status_color }}-100 text-{{ $selectedOperation->status_color }}-800">
                                        {{ $selectedOperation->status_label }}
                                    </span>
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Procedure</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedOperation->procedure_name }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Surgery Type</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedOperation->surgery_type }}</p>
                                </div>
                            </div>

                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Surgeon</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ ucwords(strtolower($selectedOperation->surgeon->name)) }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Operation Room</label>
                                    <p class="mt-1 text-sm text-gray-900">
                                        @if($selectedOperation->operationRoom)
                                            {{ $selectedOperation->operationRoom->room_number }} - {{ ucwords(strtolower($selectedOperation->operationRoom->name)) }}
                                        @else
                                            Not assigned
                                        @endif
                                    </p>
                                </div>
                            </div>

                            <div class="grid grid-cols-3 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Scheduled Date</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedOperation->scheduled_date->format('M d, Y') }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Scheduled Time</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ \Carbon\Carbon::parse($selectedOperation->scheduled_time)->format('h:i A') }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Duration</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedOperation->estimated_duration }} minutes</p>
                                </div>
                            </div>

                            @if($selectedOperation->diagnosis)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Diagnosis</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedOperation->diagnosis }}</p>
                                </div>
                            @endif

                            @if($selectedOperation->indication)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Indication</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedOperation->indication }}</p>
                                </div>
                            @endif

                            @if($selectedOperation->pre_operative_notes)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Pre-operative Notes</label>
                                    <p class="mt-1 text-sm text-gray-900 whitespace-pre-line">{{ $selectedOperation->pre_operative_notes }}</p>
                                </div>
                            @endif

                            @if($selectedOperation->operative_notes)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Operative Notes</label>
                                    <p class="mt-1 text-sm text-gray-900 whitespace-pre-line">{{ $selectedOperation->operative_notes }}</p>
                                </div>
                            @endif

                            @if($selectedOperation->post_operative_notes)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Post-operative Notes</label>
                                    <p class="mt-1 text-sm text-gray-900 whitespace-pre-line">{{ $selectedOperation->post_operative_notes }}</p>
                                </div>
                            @endif

                            @if($selectedOperation->complications)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Complications</label>
                                    <p class="mt-1 text-sm text-gray-900 whitespace-pre-line">{{ $selectedOperation->complications }}</p>
                                </div>
                            @endif

                            @if($selectedOperation->notes)
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Additional Notes</label>
                                    <p class="mt-1 text-sm text-gray-900 whitespace-pre-line">{{ $selectedOperation->notes }}</p>
                                </div>
                            @endif

                            <div class="flex justify-end space-x-3 pt-4">
                                <button wire:click="openEditModal({{ $selectedOperation->id }})" class="bg-indigo-500 hover:bg-indigo-600 text-white font-bold py-2 px-4 rounded text-sm">
                                    Edit
                                </button>
                                <button wire:click="closeModals" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Close
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
