<div>
    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <!-- Header -->
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-bold text-gray-900">Prescriptions Management</h2>
                        @if(!auth()->user()->isNurse())
                            <button wire:click="openCreateModal" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">
                                + New Prescription
                            </button>
                        @endif
                    </div>

                    @if (session()->has('message'))
                        <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                            {{ session('message') }}
                        </div>
                    @endif

                    <!-- Filters -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Search by Patient ID or Name</label>
                            <x-text-input wire:model.live.debounce.300ms="search" type="text" 
                                         placeholder="Enter patient ID or name..." 
                                         class="w-full" />
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                            <select wire:model.live="statusFilter" class="block w-full border-gray-300 rounded-md shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">All Statuses</option>
                                <option value="active">Active</option>
                                <option value="dispensed">Dispensed</option>
                                <option value="expired">Expired</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                    </div>

                    <!-- Prescriptions Table -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Prescription #</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Patient</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Drug</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Dosage</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Frequency</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($prescriptions as $prescription)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $prescription->prescription_number }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="text-sm font-medium text-gray-900">{{ $prescription->patient->full_name }}</div>
                                            <div class="text-sm text-gray-500">{{ $prescription->patient->patient_id }}</div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            <div class="font-medium">{{ ucwords(strtolower($prescription->drug->name)) }}</div>
                                            <div class="text-gray-500 text-xs">{{ ucwords(strtolower($prescription->drug->generic_name)) }}</div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $prescription->dosage }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ ucwords(strtolower($prescription->frequency)) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $prescription->prescription_date->format('M d, Y') }}
                                            <div class="text-gray-500 text-xs">Valid until: {{ $prescription->valid_until->format('M d, Y') }}</div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                @if($prescription->status === 'active') bg-green-100 text-green-800
                                                @elseif($prescription->status === 'dispensed') bg-blue-100 text-blue-800
                                                @elseif($prescription->status === 'expired') bg-red-100 text-red-800
                                                @else bg-gray-100 text-gray-800
                                                @endif">
                                                {{ ucfirst($prescription->status) }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <div class="flex space-x-2">
                                                <button wire:click="openViewModal({{ $prescription->id }})" class="text-blue-600 hover:text-blue-900">View</button>
                                                @if(!auth()->user()->isNurse())
                                                    <button wire:click="openEditModal({{ $prescription->id }})" class="text-indigo-600 hover:text-indigo-900">Edit</button>
                                                    <button wire:click="delete({{ $prescription->id }})" 
                                                        wire:confirm="Are you sure you want to delete this prescription?" 
                                                        class="text-red-600 hover:text-red-900">Delete</button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="px-6 py-4 text-center text-gray-500">No prescriptions found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-4">
                        {{ $prescriptions->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Modal -->
    @if($showCreateModal || $showEditModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-[600px] shadow-lg rounded-md bg-white max-h-[90vh] overflow-y-auto">
                <div class="mt-3">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">
                        {{ $editingPrescription ? 'Edit Prescription' : 'New Prescription' }}
                    </h3>
                    
                    <form wire:submit.prevent="save" class="space-y-4">
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <x-input-label for="patient_id" value="Patient *" />
                                <div class="relative">
                                    <input 
                                        type="text" 
                                        id="patient_search"
                                        wire:model.live.debounce.300ms="patientSearch"
                                        wire:keyup="searchPatients"
                                        placeholder="Search by name, ID, phone, or email..."
                                        class="block w-full mt-1 border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                        autocomplete="off"
                                    />
                                    @if(count($searchResults) > 0 && !$patient_id)
                                        <div class="absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-auto">
                                            @foreach($searchResults as $patient)
                                                <button 
                                                    type="button"
                                                    wire:click="selectPatient({{ $patient->id }})"
                                                    class="w-full text-left px-4 py-2 hover:bg-gray-100 focus:bg-gray-100 focus:outline-none"
                                                >
                                                    <div class="font-medium">{{ $patient->full_name }}</div>
                                                    <div class="text-sm text-gray-500">{{ $patient->patient_id }} • {{ $patient->phone ?? 'N/A' }}</div>
                                                </button>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                                @if($patient_id)
                                    <div class="mt-2 p-2 bg-green-50 border border-green-200 rounded">
                                        <span class="text-sm text-green-800">✓ Patient selected</span>
                                    </div>
                                @endif
                                <input type="hidden" wire:model="patient_id" />
                                <x-input-error :messages="$errors->get('patient_id')" class="mt-2" />
                            </div>

                            <div>
                                <x-input-label for="doctor_id" value="Doctor *" />
                                <select wire:model="doctor_id" id="doctor_id" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                    <option value="">Select Doctor</option>
                                    @foreach($doctors as $doctor)
                                        <option value="{{ $doctor->id }}">{{ ucwords(strtolower($doctor->name)) }}</option>
                                    @endforeach
                                </select>
                                <x-input-error :messages="$errors->get('doctor_id')" class="mt-2" />
                            </div>
                        </div>

                        <div>
                            <x-input-label for="drug_id" value="Drug *" />
                            <select wire:model="drug_id" id="drug_id" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">Select Drug</option>
                                @foreach($drugs as $drug)
                                    <option value="{{ $drug->id }}">{{ ucwords(strtolower($drug->name)) }} ({{ ucwords(strtolower($drug->generic_name)) }})</option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('drug_id')" class="mt-2" />
                        </div>

                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <x-input-label for="dosage" value="Dosage *" />
                                <x-text-input wire:model="dosage" id="dosage" type="text" class="block mt-1 w-full" placeholder="e.g., 500mg" />
                                <x-input-error :messages="$errors->get('dosage')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="frequency" value="Frequency *" />
                                <x-text-input wire:model="frequency" id="frequency" type="text" class="block mt-1 w-full" placeholder="e.g., Twice daily" />
                                <x-input-error :messages="$errors->get('frequency')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="quantity" value="Quantity *" />
                                <x-text-input wire:model="quantity" id="quantity" type="number" min="1" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('quantity')" class="mt-2" />
                            </div>
                        </div>

                        <div class="grid grid-cols-3 gap-4">
                            <div>
                                <x-input-label for="duration" value="Duration (days) *" />
                                <x-text-input wire:model="duration" id="duration" type="number" min="1" max="365" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('duration')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="prescription_date" value="Prescription Date *" />
                                <x-text-input wire:model="prescription_date" id="prescription_date" type="date" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('prescription_date')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="valid_until" value="Valid Until *" />
                                <x-text-input wire:model="valid_until" id="valid_until" type="date" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('valid_until')" class="mt-2" />
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <x-input-label for="status" value="Status *" />
                                <select wire:model="status" id="status" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                    <option value="active">Active</option>
                                    <option value="dispensed">Dispensed</option>
                                    <option value="expired">Expired</option>
                                    <option value="cancelled">Cancelled</option>
                                </select>
                                <x-input-error :messages="$errors->get('status')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="max_refills" value="Max Refills *" />
                                <x-text-input wire:model="max_refills" id="max_refills" type="number" min="0" max="12" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('max_refills')" class="mt-2" />
                            </div>
                        </div>

                        <div>
                            <x-input-label for="instructions" value="Instructions" />
                            <textarea wire:model="instructions" id="instructions" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" rows="2" placeholder="e.g., Take with food"></textarea>
                            <x-input-error :messages="$errors->get('instructions')" class="mt-2" />
                        </div>

                        <div>
                            <x-input-label for="notes" value="Notes" />
                            <textarea wire:model="notes" id="notes" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" rows="2"></textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                        </div>

                        <div class="flex justify-end space-x-3 pt-4">
                            <button type="button" wire:click="closeModals" class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400">
                                Cancel
                            </button>
                            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                                {{ $editingPrescription ? 'Update' : 'Create' }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif

    <!-- View Modal -->
    @if($showViewModal && $selectedPrescription)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-[700px] shadow-lg rounded-md bg-white max-h-[90vh] overflow-y-auto">
                <div class="mt-3">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-gray-900">
                            Prescription Details
                        </h3>
                        <button wire:click="closeViewModal" class="text-gray-400 hover:text-gray-500">
                            <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                    
                    <div class="space-y-4">
                        <!-- Prescription Number & Status -->
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Prescription Number</label>
                                <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->prescription_number }}</p>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Status</label>
                                <p class="mt-1">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                        @if($selectedPrescription->status === 'active') bg-green-100 text-green-800
                                        @elseif($selectedPrescription->status === 'dispensed') bg-blue-100 text-blue-800
                                        @elseif($selectedPrescription->status === 'expired') bg-red-100 text-red-800
                                        @else bg-gray-100 text-gray-800
                                        @endif">
                                        {{ ucfirst($selectedPrescription->status) }}
                                    </span>
                                </p>
                            </div>
                        </div>

                        <!-- Patient Information -->
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Patient Information</h4>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Patient Name</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->patient->full_name }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Patient ID</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->patient->patient_id }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Doctor Information -->
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Prescribing Doctor</h4>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Doctor Name</label>
                                <p class="mt-1 text-sm text-gray-900">{{ ucwords(strtolower($selectedPrescription->doctor->name)) }}</p>
                            </div>
                        </div>

                        <!-- Drug Information -->
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Medication Information</h4>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Drug Name</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ ucwords(strtolower($selectedPrescription->drug->name)) }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Generic Name</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ ucwords(strtolower($selectedPrescription->drug->generic_name)) }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Dosage Information -->
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Dosage Information</h4>
                            <div class="grid grid-cols-3 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Dosage</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->dosage }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Frequency</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->frequency }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Quantity</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->quantity }}</p>
                                </div>
                            </div>
                            <div class="grid grid-cols-2 gap-4 mt-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Duration (days)</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->duration }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Max Refills</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->max_refills }} (Used: {{ $selectedPrescription->refill_count }})</p>
                                </div>
                            </div>
                        </div>

                        <!-- Dates -->
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Dates</h4>
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Prescription Date</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->prescription_date->format('M d, Y') }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Valid Until</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->valid_until->format('M d, Y') }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Visit Information (if available) -->
                        @if($selectedPrescription->visit)
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Visit Information</h4>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">Visit Number</label>
                                <p class="mt-1 text-sm text-gray-900">{{ $selectedPrescription->visit->visit_number }}</p>
                            </div>
                        </div>
                        @endif

                        <!-- Instructions -->
                        @if($selectedPrescription->instructions)
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Instructions</h4>
                            <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $selectedPrescription->instructions }}</p>
                        </div>
                        @endif

                        <!-- Notes -->
                        @if($selectedPrescription->notes)
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Notes</h4>
                            <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $selectedPrescription->notes }}</p>
                        </div>
                        @endif

                        <!-- Pharmacy Notes -->
                        @if($selectedPrescription->pharmacy_notes)
                        <div class="border-t pt-4">
                            <h4 class="text-sm font-semibold text-gray-900 mb-3">Pharmacy Notes</h4>
                            <p class="text-sm text-gray-900 whitespace-pre-wrap">{{ $selectedPrescription->pharmacy_notes }}</p>
                        </div>
                        @endif

                        <!-- Refill Status -->
                        @if($selectedPrescription->canBeRefilled())
                        <div class="border-t pt-4">
                            <div class="p-3 bg-green-50 border border-green-200 rounded-lg">
                                <p class="text-sm text-green-800">
                                    <strong>✓ This prescription can be refilled.</strong>
                                </p>
                            </div>
                        </div>
                        @endif

                        <!-- Action Buttons -->
                        <div class="flex justify-end space-x-3 pt-4 border-t">
                            <button wire:click="closeViewModal" class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400">
                                Close
                            </button>
                            @if(!auth()->user()->isNurse())
                                <button 
                                    wire:click="openEditModal({{ $selectedPrescription->id }})" 
                                    class="px-4 py-2 bg-indigo-600 text-white rounded-lg hover:bg-indigo-700">
                                    Edit
                                </button>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>















