<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <!-- Header -->
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Inventory Management</h2>
                        <p class="text-gray-600 mt-1">Manage pharmacy stock and inventory</p>
                    </div>
                    <div class="flex gap-2">
                        <button wire:click="openBulkUploadModal" class="bg-purple-500 hover:bg-purple-600 text-white font-bold py-2 px-4 rounded">
                            📤 Bulk Upload
                        </button>
                        <button wire:click="openCreateModal" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-2 px-4 rounded">
                            + Add Stock Entry
                        </button>
                    </div>
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                @if (session()->has('bulk_upload_errors'))
                    <div class="mb-4 p-4 bg-yellow-100 border border-yellow-400 text-yellow-700 rounded">
                        <p class="font-bold">Upload Errors:</p>
                        <ul class="list-disc list-inside mt-2">
                            @foreach(session('bulk_upload_errors') as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <!-- Filters -->
                <div class="mb-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                        <input type="text" wire:model.live.debounce.300ms="search" 
                               placeholder="Search by drug name..."
                               class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Filter</label>
                        <select wire:model.live="statusFilter" 
                                class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">All Stock</option>
                            <option value="low">Low Stock</option>
                            <option value="expiring">Expiring Soon</option>
                            <option value="expired">Expired</option>
                        </select>
                    </div>
                </div>

                <!-- Stock Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Drug</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Quantity</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Reorder Level</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit Price</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Expiry Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Batch Number</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($stocks as $stock)
                                <tr class="hover:bg-gray-50 {{ $stock->isExpired() ? 'bg-red-50' : ($stock->isExpiringSoon() ? 'bg-yellow-50' : '') }}">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $stock->drug->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $stock->drug->generic_name }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm {{ $stock->isLowStock() ? 'font-bold text-red-600' : 'text-gray-900' }}">
                                        {{ $stock->quantity }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $stock->reorder_level }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        @if($stock->unit_price)
                                            {{ config('app.currency_symbol', '$') }}{{ number_format($stock->unit_price, 2) }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm {{ $stock->isExpired() ? 'text-red-600 font-bold' : ($stock->isExpiringSoon() ? 'text-yellow-600' : 'text-gray-500') }}">
                                        {{ $stock->expiry_date ? $stock->expiry_date->format('M d, Y') : '-' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $stock->batch_number ?: '-' }}</td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($stock->isExpired())
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Expired</span>
                                        @elseif($stock->isExpiringSoon())
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Expiring Soon</span>
                                        @elseif($stock->isLowStock())
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-orange-100 text-orange-800">Low Stock</span>
                                        @else
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">In Stock</span>
                                        @endif
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex justify-end space-x-2">
                                            <button wire:click="openEditModal({{ $stock->id }})" 
                                                    class="text-blue-600 hover:text-blue-900">Edit</button>
                                            <button wire:click="delete({{ $stock->id }})" 
                                                    wire:confirm="Are you sure you want to delete this stock entry?"
                                                    class="text-red-600 hover:text-red-900">Delete</button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="px-6 py-4 text-center text-sm text-gray-500">
                                        No stock entries found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    {{ $stocks->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Modal -->
    @if($showModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-2/3 lg:w-1/2 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-bold text-gray-900">
                        {{ $editingStock ? 'Edit Stock Entry' : 'Create New Stock Entry' }}
                    </h3>
                    <button wire:click="closeModal" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>

                <form wire:submit.prevent="save">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Drug -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Drug <span class="text-red-500">*</span></label>
                            <select wire:model="drug_id" 
                                    class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                                <option value="">Select Drug</option>
                                @foreach($drugs as $drug)
                                    <option value="{{ $drug->id }}">{{ $drug->name }} ({{ $drug->generic_name }})</option>
                                @endforeach
                            </select>
                            @error('drug_id') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Quantity -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Quantity <span class="text-red-500">*</span></label>
                            <input type="number" wire:model="quantity" min="0" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('quantity') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Reorder Level -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Reorder Level <span class="text-red-500">*</span></label>
                            <input type="number" wire:model="reorder_level" min="0" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('reorder_level') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Unit Price -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Unit Price</label>
                            <div class="relative">
                                <span class="absolute left-3 top-2 text-gray-500">{{ config('app.currency_symbol', '$') }}</span>
                                <input type="number" wire:model="unit_price" step="0.01" min="0" 
                                       class="block w-full pl-8 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                       placeholder="0.00">
                            </div>
                            @error('unit_price') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Expiry Date -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Expiry Date</label>
                            <input type="date" wire:model="expiry_date" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('expiry_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Batch Number -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Batch Number</label>
                            <input type="text" wire:model="batch_number" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('batch_number') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Supplier -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Supplier</label>
                            <input type="text" wire:model="supplier" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('supplier') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Supply Date -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Supply Date</label>
                            <input type="date" wire:model="supply_date" 
                                   class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            @error('supply_date') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>

                        <!-- Notes -->
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Notes</label>
                            <textarea wire:model="notes" rows="3" 
                                      class="block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500"
                                      placeholder="Additional notes..."></textarea>
                            @error('notes') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="mt-6 flex justify-end space-x-3">
                        <button type="button" wire:click="closeModal" 
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                            {{ $editingStock ? 'Update Stock' : 'Create Stock Entry' }}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <!-- Bulk Upload Modal -->
    @if($showBulkUploadModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeBulkUploadModal">
            <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-2/3 lg:w-1/2 shadow-lg rounded-md bg-white" wire:click.stop>
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-bold text-gray-900">Bulk Upload Inventory</h3>
                    <button wire:click="closeBulkUploadModal" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>

                <div class="mb-4 p-4 bg-blue-50 border border-blue-200 rounded">
                    <h4 class="font-semibold text-blue-900 mb-2">CSV Format Requirements:</h4>
                    <p class="text-sm text-blue-800 mb-2">Upload a CSV file with the following columns (header row optional):</p>
                    <ul class="text-sm text-blue-800 list-disc list-inside space-y-1">
                        <li><strong>drug_name</strong> - Drug name (required, must exist in drug catalog)</li>
                        <li><strong>quantity</strong> - Quantity in stock (required)</li>
                        <li><strong>reorder_level</strong> - Reorder level (optional, default: 10)</li>
                        <li><strong>unit_price</strong> - Unit price (optional)</li>
                        <li><strong>expiry_date</strong> - Expiry date YYYY-MM-DD (optional)</li>
                        <li><strong>batch_number</strong> - Batch number (optional)</li>
                        <li><strong>supplier</strong> - Supplier name (optional)</li>
                        <li><strong>supply_date</strong> - Supply date YYYY-MM-DD (optional, default: today)</li>
                        <li><strong>notes</strong> - Additional notes (optional)</li>
                    </ul>
                    <p class="text-xs text-blue-700 mt-2">Example: Panadol,100,10,50.00,2025-12-31,BATCH001,Supplier ABC,2024-01-15,Initial stock</p>
                    <p class="text-xs text-red-700 mt-2 font-semibold">⚠️ Note: Drugs must exist in the drug catalog before uploading inventory.</p>
                </div>

                <form wire:submit.prevent="processBulkUpload">
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-gray-700 mb-1">CSV File <span class="text-red-500">*</span></label>
                        <input type="file" wire:model="bulk_upload_file" accept=".csv,.txt"
                               class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                        @error('bulk_upload_file') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
                        @if($bulk_upload_file)
                            <p class="mt-1 text-sm text-gray-600">Selected: {{ $bulk_upload_file->getClientOriginalName() }}</p>
                        @endif
                    </div>

                    <div class="mt-6 flex justify-end space-x-3">
                        <button type="button" wire:click="closeBulkUploadModal" 
                                class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400">
                            Cancel
                        </button>
                        <button type="submit" 
                                class="px-4 py-2 bg-purple-500 text-white rounded hover:bg-purple-600">
                            Upload & Process
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>
