<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <!-- Header Section -->
        <div class="mb-6">
            <div class="flex items-center justify-between">
                <div class="flex-1">
                    <a href="{{ route('drugs.index') }}" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-sm font-medium mb-3 transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                        Back to Drug List
                    </a>
                    <div class="flex items-center gap-4">
                        <div>
                            <h1 class="text-3xl font-bold text-gray-900">{{ $drug->name }}</h1>
                            <p class="text-lg text-gray-600 mt-1">{{ $drug->generic_name }}</p>
                        </div>
                        <div>
                            <span class="px-3 py-1 text-sm font-semibold rounded-full {{ $drug->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $drug->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </div>
                    </div>
                </div>
                <div>
                    <a href="{{ route('drugs.index') }}" 
                       class="inline-flex items-center px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition-colors">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                        Back to List
                    </a>
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
            <!-- Total Stock Card -->
            <div class="bg-gradient-to-br from-blue-50 to-blue-100 border border-blue-200 rounded-xl shadow-sm hover:shadow-md transition-shadow">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-sm font-medium text-blue-700 mb-1">Total Stock</p>
                            <p class="text-3xl font-bold text-blue-900">{{ number_format($totalStock) }}</p>
                            <p class="text-xs text-blue-600 mt-1">units</p>
                        </div>
                        <div class="w-12 h-12 bg-blue-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Available Stock Card -->
            <div class="bg-gradient-to-br from-green-50 to-green-100 border border-green-200 rounded-xl shadow-sm hover:shadow-md transition-shadow">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-sm font-medium text-green-700 mb-1">Available Stock</p>
                            <p class="text-3xl font-bold text-green-900">{{ number_format($availableStock) }}</p>
                            <p class="text-xs text-green-600 mt-1">units</p>
                        </div>
                        <div class="w-12 h-12 bg-green-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Expired Stock Card (if any) -->
            @if($expiredStock > 0)
            <div class="bg-gradient-to-br from-red-50 to-red-100 border border-red-200 rounded-xl shadow-sm hover:shadow-md transition-shadow">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-sm font-medium text-red-700 mb-1">Expired Stock</p>
                            <p class="text-3xl font-bold text-red-900">{{ number_format($expiredStock) }}</p>
                            <p class="text-xs text-red-600 mt-1">units</p>
                        </div>
                        <div class="w-12 h-12 bg-red-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            <!-- Prescriptions Card -->
            <div class="bg-gradient-to-br from-purple-50 to-purple-100 border border-purple-200 rounded-xl shadow-sm hover:shadow-md transition-shadow">
                <div class="p-6">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <p class="text-sm font-medium text-purple-700 mb-1">Prescriptions</p>
                            <p class="text-3xl font-bold text-purple-900">{{ number_format($prescriptionCount) }}</p>
                            <p class="text-xs text-purple-600 mt-1">total</p>
                        </div>
                        <div class="w-12 h-12 bg-purple-500 rounded-lg flex items-center justify-center shadow-sm">
                            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Left Column - Main Details -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Basic Information -->
                <div class="bg-white shadow-lg rounded-xl overflow-hidden border border-gray-200">
                    <div class="px-6 py-4 bg-gradient-to-r from-gray-50 to-gray-100 border-b border-gray-200">
                        <div class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <h3 class="text-lg font-bold text-gray-900">Basic Information</h3>
                        </div>
                    </div>
                    <div class="p-6">
                        <dl class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Drug Name</dt>
                                <dd class="text-base font-semibold text-gray-900">{{ $drug->name }}</dd>
                            </div>
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Generic Name</dt>
                                <dd class="text-base text-gray-700">{{ $drug->generic_name }}</dd>
                            </div>
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Manufacturer</dt>
                                <dd class="text-base text-gray-700">{{ $drug->manufacturer }}</dd>
                            </div>
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Category</dt>
                                <dd>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-blue-100 text-blue-800">
                                        {{ $drug->category_name }}
                                    </span>
                                </dd>
                            </div>
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Dosage Form</dt>
                                <dd class="text-base text-gray-700">{{ $drug->dosage_form }}</dd>
                            </div>
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Strength</dt>
                                <dd class="text-base text-gray-700 font-medium">{{ $drug->strength }} {{ $drug->unit }}</dd>
                            </div>
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Status</dt>
                                <dd>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold {{ $drug->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                        {{ $drug->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </dd>
                            </div>
                            <div class="space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Prescription Required</dt>
                                <dd class="text-base text-gray-700">
                                    <span class="inline-flex items-center">
                                        @if($drug->prescription_required)
                                            <svg class="w-5 h-5 text-green-500 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                            </svg>
                                            <span class="text-green-700 font-medium">Yes</span>
                                        @else
                                            <svg class="w-5 h-5 text-gray-400 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"></path>
                                            </svg>
                                            <span class="text-gray-600">No</span>
                                        @endif
                                    </span>
                                </dd>
                            </div>
                            @if($drug->description)
                            <div class="md:col-span-2 space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Description</dt>
                                <dd class="text-sm text-gray-700 leading-relaxed">{{ $drug->description }}</dd>
                            </div>
                            @endif
                            @if($drug->storage_conditions)
                            <div class="md:col-span-2 space-y-1">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide">Storage Conditions</dt>
                                <dd class="text-sm text-gray-700">
                                    <div class="flex items-start">
                                        <svg class="w-5 h-5 text-blue-500 mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                                        </svg>
                                        <span class="leading-relaxed">{{ $drug->storage_conditions }}</span>
                                    </div>
                                </dd>
                            </div>
                            @endif
                        </dl>
                    </div>
                </div>

                <!-- Side Effects -->
                @if($drug->side_effects && count($drug->side_effects) > 0)
                <div class="bg-white shadow-lg rounded-xl overflow-hidden border-l-4 border-red-500">
                    <div class="px-6 py-4 bg-gradient-to-r from-red-50 to-red-100 border-b border-red-200">
                        <div class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                            <h3 class="text-lg font-bold text-red-900">Side Effects</h3>
                        </div>
                    </div>
                    <div class="p-6">
                        <ul class="space-y-3">
                            @foreach($drug->side_effects as $effect)
                            <li class="flex items-start group">
                                <svg class="w-5 h-5 text-red-500 mr-3 mt-0.5 flex-shrink-0 group-hover:text-red-600 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <span class="text-sm text-gray-700 leading-relaxed flex-1">{{ $effect }}</span>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                @endif

                <!-- Contraindications -->
                @if($drug->contraindications && count($drug->contraindications) > 0)
                <div class="bg-white shadow-lg rounded-xl overflow-hidden border-l-4 border-orange-500">
                    <div class="px-6 py-4 bg-gradient-to-r from-orange-50 to-orange-100 border-b border-orange-200">
                        <div class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                            <h3 class="text-lg font-bold text-orange-900">Contraindications</h3>
                        </div>
                    </div>
                    <div class="p-6">
                        <ul class="space-y-3">
                            @foreach($drug->contraindications as $contra)
                            <li class="flex items-start group">
                                <svg class="w-5 h-5 text-orange-500 mr-3 mt-0.5 flex-shrink-0 group-hover:text-orange-600 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                </svg>
                                <span class="text-sm text-gray-700 leading-relaxed flex-1">{{ $contra }}</span>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                @endif

                <!-- Drug Interactions -->
                @if($drug->interactions && count($drug->interactions) > 0)
                <div class="bg-white shadow-lg rounded-xl overflow-hidden border-l-4 border-yellow-500">
                    <div class="px-6 py-4 bg-gradient-to-r from-yellow-50 to-yellow-100 border-b border-yellow-200">
                        <div class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                            <h3 class="text-lg font-bold text-yellow-900">Drug Interactions</h3>
                        </div>
                    </div>
                    <div class="p-6">
                        <ul class="space-y-3">
                            @foreach($drug->interactions as $interaction)
                            <li class="flex items-start group">
                                <svg class="w-5 h-5 text-yellow-500 mr-3 mt-0.5 flex-shrink-0 group-hover:text-yellow-600 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                                </svg>
                                <span class="text-sm text-gray-700 leading-relaxed flex-1">{{ $interaction }}</span>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                @endif

                <!-- Stock Entries -->
                <div class="bg-white shadow-lg rounded-xl overflow-hidden border border-gray-200">
                    <div class="px-6 py-4 bg-gradient-to-r from-gray-50 to-gray-100 border-b border-gray-200">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center gap-2">
                                <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                </svg>
                                <h3 class="text-lg font-bold text-gray-900">Stock Entries</h3>
                            </div>
                            <a href="{{ route('inventory.index') }}?search={{ urlencode($drug->name) }}" 
                               class="text-sm font-medium text-blue-600 hover:text-blue-800 inline-flex items-center transition-colors">
                                View All in Inventory
                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Quantity</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Unit Price</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Expiry Date</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Batch Number</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Supplier</th>
                                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">Status</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse($drug->pharmacyStocks as $stock)
                                <tr class="hover:bg-gray-50 transition-colors {{ $stock->isExpired() ? 'bg-red-50' : ($stock->isExpiringSoon() ? 'bg-yellow-50' : '') }}">
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-semibold {{ $stock->isLowStock() ? 'text-red-600' : 'text-gray-900' }}">
                                            {{ number_format($stock->quantity) }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-900">
                                            @if($stock->unit_price)
                                                {{ config('app.currency_symbol', '₦') }}{{ number_format($stock->unit_price, 2) }}
                                            @else
                                                <span class="text-gray-400">-</span>
                                            @endif
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium {{ $stock->isExpired() ? 'text-red-600' : ($stock->isExpiringSoon() ? 'text-yellow-600' : 'text-gray-500') }}">
                                            {{ $stock->expiry_date ? $stock->expiry_date->format('M d, Y') : '-' }}
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-600 font-mono">{{ $stock->batch_number ?: '-' }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm text-gray-600">{{ $stock->supplier ?: '-' }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        @if($stock->isExpired())
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-red-100 text-red-800">
                                                Expired
                                            </span>
                                        @elseif($stock->isExpiringSoon())
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-yellow-100 text-yellow-800">
                                                Expiring Soon
                                            </span>
                                        @elseif($stock->isLowStock())
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-orange-100 text-orange-800">
                                                Low Stock
                                            </span>
                                        @else
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-semibold bg-green-100 text-green-800">
                                                In Stock
                                            </span>
                                        @endif
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="px-6 py-8 text-center">
                                        <div class="flex flex-col items-center">
                                            <svg class="w-12 h-12 text-gray-400 mb-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                            </svg>
                                            <p class="text-sm text-gray-500 mb-2">No stock entries found</p>
                                            <a href="{{ route('inventory.index') }}" class="text-sm text-blue-600 hover:text-blue-800 font-medium">
                                                Add stock entry →
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Right Column - Alerts & Info -->
            <div class="space-y-6">
                <!-- Status Alerts -->
                @if($lowStockEntries->count() > 0)
                <div class="bg-gradient-to-br from-orange-50 to-orange-100 border-l-4 border-orange-500 rounded-lg shadow-sm">
                    <div class="p-5">
                        <div class="flex items-start">
                            <div class="flex-shrink-0">
                                <svg class="h-6 w-6 text-orange-500" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="ml-4 flex-1">
                                <h3 class="text-sm font-bold text-orange-900 mb-1">Low Stock Alert</h3>
                                <p class="text-sm text-orange-800 leading-relaxed">
                                    {{ $lowStockEntries->count() }} stock {{ $lowStockEntries->count() === 1 ? 'entry' : 'entries' }} {{ $lowStockEntries->count() === 1 ? 'is' : 'are' }} below reorder level.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                @if($expiringSoonEntries->count() > 0)
                <div class="bg-gradient-to-br from-yellow-50 to-yellow-100 border-l-4 border-yellow-500 rounded-lg shadow-sm">
                    <div class="p-5">
                        <div class="flex items-start">
                            <div class="flex-shrink-0">
                                <svg class="h-6 w-6 text-yellow-500" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                </svg>
                            </div>
                            <div class="ml-4 flex-1">
                                <h3 class="text-sm font-bold text-yellow-900 mb-1">Expiring Soon</h3>
                                <p class="text-sm text-yellow-800 leading-relaxed">
                                    {{ $expiringSoonEntries->count() }} stock {{ $expiringSoonEntries->count() === 1 ? 'entry' : 'entries' }} {{ $expiringSoonEntries->count() === 1 ? 'is' : 'are' }} expiring within 30 days.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

                <!-- Additional Information -->
                <div class="bg-white shadow-lg rounded-xl overflow-hidden border border-gray-200">
                    <div class="px-6 py-4 bg-gradient-to-r from-gray-50 to-gray-100 border-b border-gray-200">
                        <div class="flex items-center gap-2">
                            <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <h3 class="text-lg font-bold text-gray-900">Additional Information</h3>
                        </div>
                    </div>
                    <div class="p-6">
                        <dl class="space-y-5">
                            <div class="pb-4 border-b border-gray-100">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-1">Expiry Alert Days</dt>
                                <dd class="text-base font-semibold text-gray-900">{{ $drug->expiry_alert_days }} days</dd>
                            </div>
                            <div class="pb-4 border-b border-gray-100">
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-1">Created</dt>
                                <dd class="text-sm text-gray-700">{{ $drug->created_at->format('M d, Y') }}</dd>
                                <dd class="text-xs text-gray-500 mt-0.5">{{ $drug->created_at->format('h:i A') }}</dd>
                            </div>
                            <div>
                                <dt class="text-xs font-semibold text-gray-500 uppercase tracking-wide mb-1">Last Updated</dt>
                                <dd class="text-sm text-gray-700">{{ $drug->updated_at->format('M d, Y') }}</dd>
                                <dd class="text-xs text-gray-500 mt-0.5">{{ $drug->updated_at->format('h:i A') }}</dd>
                            </div>
                        </dl>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
