<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <!-- Header -->
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
            <div class="p-6">
                <div class="flex justify-between items-center">
                    <div>
                        <h1 class="text-3xl font-bold text-gray-900">{{ $patient->full_name }}</h1>
                        <p class="text-gray-600 mt-1">Patient ID: {{ $patient->patient_id }}</p>
                        <p class="text-gray-600">{{ $patient->age }} years old • {{ ucfirst($patient->gender) }}</p>
                    </div>
                    <div class="flex space-x-4">
                        @if(!auth()->user()->isDoctor())
                            <button wire:click="toggleEdit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                                {{ $editing ? 'Cancel' : 'Edit Profile' }}
                            </button>
                        @endif
                        <a href="{{ route('patients.index') }}" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded">
                            Back to List
                        </a>
                    </div>
                </div>
            </div>
        </div>

        @if (session()->has('message'))
            <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                {{ session('message') }}
            </div>
        @endif

        <!-- Tabs Navigation -->
        <div class="bg-white shadow-sm sm:rounded-lg mb-6">
            <div class="px-6 pt-6">
                @include('livewire.patients.patient-profile-tabs')
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Content Area -->
            <div class="lg:col-span-2">
                @if($activeTab === 'overview')
                    <!-- Overview Tab -->
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6">
                            <h2 class="text-xl font-semibold text-gray-900 mb-4">Patient Information</h2>
                        
                        @if($editing)
                            <form wire:submit="save" class="space-y-6">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <x-input-label for="first_name" :value="__('First Name')" />
                                        <x-text-input id="first_name" class="block mt-1 w-full" type="text" wire:model="first_name" required />
                                        <x-input-error :messages="$errors->get('first_name')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="last_name" :value="__('Last Name')" />
                                        <x-text-input id="last_name" class="block mt-1 w-full" type="text" wire:model="last_name" required />
                                        <x-input-error :messages="$errors->get('last_name')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="date_of_birth" :value="__('Date of Birth')" />
                                        <x-text-input id="date_of_birth" class="block mt-1 w-full" type="date" wire:model="date_of_birth" required />
                                        <x-input-error :messages="$errors->get('date_of_birth')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="gender" :value="__('Gender')" />
                                        <select id="gender" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="gender" required>
                                            <option value="male">Male</option>
                                            <option value="female">Female</option>
                                            <option value="other">Other</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('gender')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="email" :value="__('Email')" />
                                        <x-text-input id="email" class="block mt-1 w-full" type="email" wire:model="email" />
                                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="phone" :value="__('Phone Number')" />
                                        <x-text-input id="phone" class="block mt-1 w-full" type="tel" wire:model="phone" />
                                        <x-input-error :messages="$errors->get('phone')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="blood_type" :value="__('Blood Type')" />
                                        <select id="blood_type" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="blood_type">
                                            <option value="">Select Blood Type</option>
                                            <option value="A+">A+</option>
                                            <option value="A-">A-</option>
                                            <option value="B+">B+</option>
                                            <option value="B-">B-</option>
                                            <option value="AB+">AB+</option>
                                            <option value="AB-">AB-</option>
                                            <option value="O+">O+</option>
                                            <option value="O-">O-</option>
                                        </select>
                                        <x-input-error :messages="$errors->get('blood_type')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="height" :value="__('Height (cm)')" />
                                        <x-text-input id="height" class="block mt-1 w-full" type="number" step="0.1" wire:model="height" />
                                        <x-input-error :messages="$errors->get('height')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="weight" :value="__('Weight (kg)')" />
                                        <x-text-input id="weight" class="block mt-1 w-full" type="number" step="0.1" wire:model="weight" />
                                        <x-input-error :messages="$errors->get('weight')" class="mt-2" />
                                    </div>
                                </div>

                                <div>
                                    <x-input-label for="address" :value="__('Address')" />
                                    <textarea id="address" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="address"></textarea>
                                    <x-input-error :messages="$errors->get('address')" class="mt-2" />
                                </div>

                                <div>
                                    <x-input-label for="medical_history" :value="__('Medical History')" />
                                    <textarea id="medical_history" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="4" wire:model="medical_history" placeholder="Previous medical conditions, surgeries, chronic diseases, etc."></textarea>
                                    <x-input-error :messages="$errors->get('medical_history')" class="mt-2" />
                                </div>

                                <div>
                                    <x-input-label for="allergies" :value="__('Allergies')" />
                                    <textarea id="allergies" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="allergies" placeholder="Known allergies, reactions to medications, food allergies, etc."></textarea>
                                    <x-input-error :messages="$errors->get('allergies')" class="mt-2" />
                                </div>

                                <div class="flex justify-end space-x-4">
                                    <button type="button" wire:click="toggleEdit" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded">
                                        Cancel
                                    </button>
                                    <x-primary-button wire:loading.attr="disabled" wire:target="save">
                                        <span wire:loading.remove wire:target="save">Save Changes</span>
                                        <span wire:loading wire:target="save">Saving...</span>
                                    </x-primary-button>
                                </div>
                            </form>
                        @else
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Email</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $patient->email ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Phone</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $patient->phone ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Date of Birth</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $patient->date_of_birth->format('M d, Y') }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Blood Type</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $patient->blood_type ?? 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Height</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $patient->height ? $patient->height . ' cm' : 'N/A' }}</p>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Weight</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $patient->weight ? $patient->weight . ' kg' : 'N/A' }}</p>
                                </div>
                            </div>
                            @if($patient->address)
                                <div class="mt-6">
                                    <label class="block text-sm font-medium text-gray-700">Address</label>
                                    <p class="mt-1 text-sm text-gray-900">{{ $patient->display_address ?? 'N/A' }}</p>
                                </div>
                            @endif
                            @if($patient->medical_history)
                                <div class="mt-6">
                                    <label class="block text-sm font-medium text-gray-700">Medical History</label>
                                    <p class="mt-1 text-sm text-gray-900 whitespace-pre-line">{{ $patient->medical_history }}</p>
                                </div>
                            @endif
                            @if($patient->allergies)
                                <div class="mt-6">
                                    <label class="block text-sm font-medium text-gray-700">Allergies</label>
                                    <p class="mt-1 text-sm text-red-900 whitespace-pre-line font-medium">{{ $patient->allergies }}</p>
                                </div>
                            @endif
                        @endif
                    </div>
                </div>
                @elseif($activeTab === 'history')
                    <!-- Medical History Tab -->
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6">
                            <div class="flex justify-between items-center mb-6">
                                <h2 class="text-xl font-semibold text-gray-900">Medical History</h2>
                                @if(!$editingHistory && !auth()->user()->isDoctor())
                                    <button wire:click="toggleEditHistory" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded text-sm">
                                        Edit History
                                    </button>
                                @endif
                            </div>
                            
                            @if($editingHistory)
                                <form wire:submit.prevent="saveHistory" class="space-y-6">
                                    <div>
                                        <x-input-label for="medical_history" :value="__('Medical History')" />
                                        <textarea id="medical_history" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="6" wire:model="medical_history" placeholder="Previous medical conditions, surgeries, chronic diseases, etc."></textarea>
                                        <x-input-error :messages="$errors->get('medical_history')" class="mt-2" />
                                    </div>

                                    <div>
                                        <x-input-label for="allergies" :value="__('Allergies')" />
                                        <textarea id="allergies" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="4" wire:model="allergies" placeholder="Known allergies, reactions to medications, food allergies, etc."></textarea>
                                        <x-input-error :messages="$errors->get('allergies')" class="mt-2" />
                                    </div>

                                    <div class="flex justify-end space-x-4">
                                        <button type="button" wire:click="toggleEditHistory" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded">
                                            Cancel
                                        </button>
                                        <x-primary-button wire:loading.attr="disabled" wire:target="saveHistory">
                                            <span wire:loading.remove wire:target="saveHistory">Save Changes</span>
                                            <span wire:loading wire:target="saveHistory">Saving...</span>
                                        </x-primary-button>
                                    </div>
                                </form>
                            @else
                                @if($patient->medical_history || $patient->allergies)
                                    <div class="space-y-6">
                                        @if($patient->medical_history)
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-2">Medical History</label>
                                                <div class="bg-gray-50 rounded-lg p-4">
                                                    <p class="text-sm text-gray-900 whitespace-pre-line">{{ $patient->medical_history }}</p>
                                                </div>
                                            </div>
                                        @endif

                                        @if($patient->allergies)
                                            <div>
                                                <label class="block text-sm font-medium text-gray-700 mb-2">Allergies</label>
                                                <div class="bg-red-50 border border-red-200 rounded-lg p-4">
                                                    <p class="text-sm text-red-900 whitespace-pre-line font-medium">{{ $patient->allergies }}</p>
                                                </div>
                                            </div>
                                        @endif
                                    </div>
                                @else
                                    <p class="text-gray-500 text-center py-8">No medical history recorded yet.</p>
                                @endif
                            @endif

                            <!-- Medical Records List -->
                            <div class="mt-8">
                                <div class="flex justify-between items-center mb-4">
                                    <h3 class="text-lg font-semibold text-gray-900">Medical Records</h3>
                                    @if(!auth()->user()->isDoctor())
                                        <button wire:click="openRecordModal" class="bg-green-500 hover:bg-green-700 text-white font-bold py-2 px-4 rounded text-sm">
                                            Add New Record
                                        </button>
                                    @endif
                                </div>
                                @if($patient->medicalRecords->count() > 0)
                                    <div class="space-y-4">
                                        @foreach($patient->medicalRecords->sortByDesc('visit_date') as $record)
                                            <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                                                <div class="flex justify-between items-start mb-2">
                                                    <div class="flex-1">
                                                        <h4 class="font-medium text-gray-900">{{ ucfirst(str_replace('_', ' ', $record->visit_type)) }}</h4>
                                                        <p class="text-sm text-gray-500">{{ $record->visit_date->format('M d, Y') }} • Dr. {{ ucwords(strtolower($record->doctor->name)) }}</p>
                                                    </div>
                                                    @if(!auth()->user()->isDoctor())
                                                        <div class="flex space-x-2">
                                                            <button wire:click="openRecordModal({{ $record->id }})" class="text-blue-600 hover:text-blue-800 text-sm font-medium">
                                                                Edit
                                                            </button>
                                                            <button wire:click="deleteRecord({{ $record->id }})" wire:confirm="Are you sure you want to delete this medical record?" class="text-red-600 hover:text-red-800 text-sm font-medium">
                                                                Delete
                                                            </button>
                                                        </div>
                                                    @endif
                                                </div>
                                                @if($record->symptoms)
                                                    <div class="mt-2">
                                                        <span class="text-xs font-medium text-gray-600">Symptoms:</span>
                                                        <p class="text-sm text-gray-900 mt-1">{{ $record->symptoms }}</p>
                                                    </div>
                                                @endif
                                                @if($record->diagnosis)
                                                    <div class="mt-2">
                                                        <span class="text-xs font-medium text-gray-600">Diagnosis:</span>
                                                        <p class="text-sm text-gray-900 mt-1">{{ $record->diagnosis }}</p>
                                                    </div>
                                                @endif
                                                @if($record->treatment_plan)
                                                    <div class="mt-2">
                                                        <span class="text-xs font-medium text-gray-600">Treatment Plan:</span>
                                                        <p class="text-sm text-gray-900 mt-1">{{ $record->treatment_plan }}</p>
                                                    </div>
                                                @endif
                                                @if($record->notes)
                                                    <div class="mt-2">
                                                        <span class="text-xs font-medium text-gray-600">Notes:</span>
                                                        <p class="text-sm text-gray-900 mt-1">{{ $record->notes }}</p>
                                                    </div>
                                                @endif
                                                @if($record->follow_up_date)
                                                    <div class="mt-2">
                                                        <span class="text-xs font-medium text-gray-600">Follow-up Date:</span>
                                                        <p class="text-sm text-gray-900 mt-1">{{ $record->follow_up_date->format('M d, Y') }}</p>
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="text-gray-500 text-center py-8">No medical records found.</p>
                                @endif
                            </div>

                            <!-- Audit Log Section -->
                            <div class="mt-8 border-t border-gray-200 pt-8">
                                <h3 class="text-lg font-semibold text-gray-900 mb-4">Change History</h3>
                                @php
                                    $auditLogs = \App\Services\AuditLogService::getPatientLogs($patient->id, null);
                                    $historyLogs = $auditLogs->filter(function($log) {
                                        return in_array($log->field_name, ['medical_history', 'allergies']);
                                    });
                                @endphp
                                @if($historyLogs->count() > 0)
                                    <div class="space-y-3">
                                        @foreach($historyLogs as $log)
                                            <div class="bg-gray-50 border border-gray-200 rounded-lg p-4">
                                                <div class="flex justify-between items-start mb-2">
                                                    <div class="flex-1">
                                                        <div class="flex items-center gap-2 mb-1">
                                                            <span class="font-medium text-sm text-gray-900">{{ $log->field_label }}</span>
                                                            <span class="px-2 py-0.5 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                                                                {{ $log->action_label }}
                                                            </span>
                                                        </div>
                                                        <p class="text-xs text-gray-500">
                                                            by {{ $log->user ? ucwords(strtolower($log->user->name)) : 'System' }}
                                                            @if($log->visit)
                                                                • Visit: {{ $log->visit->visit_number }}
                                                            @endif
                                                            • {{ $log->created_at->format('M d, Y h:i A') }}
                                                        </p>
                                                    </div>
                                                </div>
                                                @if($log->old_value || $log->new_value)
                                                    <div class="mt-2 space-y-1 text-xs">
                                                        @if($log->old_value)
                                                            <div class="bg-red-50 border border-red-200 rounded p-2">
                                                                <span class="font-medium text-red-800">Previous:</span>
                                                                <p class="text-red-700 mt-1 whitespace-pre-line">{{ strlen($log->old_value) > 200 ? substr($log->old_value, 0, 200) . '...' : $log->old_value }}</p>
                                                            </div>
                                                        @endif
                                                        @if($log->new_value)
                                                            <div class="bg-green-50 border border-green-200 rounded p-2">
                                                                <span class="font-medium text-green-800">New:</span>
                                                                <p class="text-green-700 mt-1 whitespace-pre-line">{{ strlen($log->new_value) > 200 ? substr($log->new_value, 0, 200) . '...' : $log->new_value }}</p>
                                                            </div>
                                                        @endif
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <p class="text-sm text-gray-500 text-center py-4">No change history recorded yet.</p>
                                @endif
                            </div>
                        </div>
                    </div>
                @elseif($activeTab === 'appointments')
                    <!-- Appointments Tab -->
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6">
                            <div class="flex justify-between items-center mb-6">
                                <h2 class="text-xl font-semibold text-gray-900">Appointments</h2>
                                <a href="{{ route('appointments.index') }}" class="text-sm text-blue-600 hover:text-blue-700">View All →</a>
                            </div>
                            
                            @if($patient->appointments->count() > 0)
                                <div class="space-y-4">
                                    @foreach($patient->appointments->sortByDesc('appointment_date') as $appointment)
                                        <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                                            <div class="flex justify-between items-start">
                                                <div class="flex-1">
                                                    <div class="flex items-center gap-3 mb-2">
                                                        <h4 class="font-medium text-gray-900">{{ ucfirst(str_replace('_', ' ', $appointment->type)) }}</h4>
                                                        <span class="px-2 py-1 text-xs font-semibold rounded-full
                                                            @if($appointment->status === 'completed') bg-green-100 text-green-800
                                                            @elseif($appointment->status === 'cancelled' || $appointment->status === 'no_show') bg-red-100 text-red-800
                                                            @elseif($appointment->status === 'in_progress') bg-purple-100 text-purple-800
                                                            @elseif($appointment->status === 'confirmed') bg-blue-100 text-blue-800
                                                            @else bg-yellow-100 text-yellow-800
                                                            @endif">
                                                            {{ ucfirst(str_replace('_', ' ', $appointment->status)) }}
                                                        </span>
                                                    </div>
                                                    <p class="text-sm text-gray-600">
                                                        <span class="font-medium">{{ $appointment->appointment_date->format('M d, Y') }}</span>
                                                        at <span class="font-medium">{{ \Carbon\Carbon::parse($appointment->appointment_time)->format('h:i A') }}</span>
                                                    </p>
                                                    <p class="text-sm text-gray-500 mt-1">Dr. {{ ucwords(strtolower($appointment->doctor->name)) }} • {{ $appointment->duration }} minutes</p>
                                                    @if($appointment->reason)
                                                        <p class="text-sm text-gray-700 mt-2">Reason: {{ $appointment->reason }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-gray-500 text-center py-8">No appointments found.</p>
                            @endif
                        </div>
                    </div>
                @elseif($activeTab === 'prescriptions')
                    <!-- Prescriptions Tab -->
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div class="p-6">
                            <div class="flex justify-between items-center mb-6">
                                <h2 class="text-xl font-semibold text-gray-900">Prescriptions</h2>
                                <a href="{{ route('prescriptions.index') }}" class="text-sm text-blue-600 hover:text-blue-700">View All →</a>
                            </div>
                            
                            @if($patient->prescriptions->count() > 0)
                                <div class="space-y-4">
                                    @foreach($patient->prescriptions->sortByDesc('prescription_date') as $prescription)
                                        <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50 transition-colors">
                                            <div class="flex justify-between items-start">
                                                <div class="flex-1">
                                                    <div class="flex items-center gap-3 mb-2">
                                                        <h4 class="font-medium text-gray-900">{{ $prescription->drug ? ucwords(strtolower($prescription->drug->name)) : 'Unknown Drug' }}</h4>
                                                        <span class="px-2 py-1 text-xs font-semibold rounded-full
                                                            @if($prescription->status === 'active') bg-green-100 text-green-800
                                                            @elseif($prescription->status === 'expired') bg-red-100 text-red-800
                                                            @else bg-gray-100 text-gray-800
                                                            @endif">
                                                            {{ ucfirst($prescription->status) }}
                                                        </span>
                                                    </div>
                                                    <p class="text-sm text-gray-600">
                                                        <span class="font-medium">{{ $prescription->prescription_date->format('M d, Y') }}</span>
                                                        by Dr. {{ ucwords(strtolower($prescription->doctor->name)) }}
                                                    </p>
                                                    <div class="mt-2 text-sm text-gray-700">
                                                        <p><span class="font-medium">Dosage:</span> {{ $prescription->dosage }}</p>
                                                        <p><span class="font-medium">Frequency:</span> {{ $prescription->frequency }}</p>
                                                        <p><span class="font-medium">Duration:</span> {{ $prescription->duration }}</p>
                                                    </div>
                                                    @if($prescription->instructions)
                                                        <p class="text-sm text-gray-700 mt-2"><span class="font-medium">Instructions:</span> {{ $prescription->instructions }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                <p class="text-gray-500 text-center py-8">No prescriptions found.</p>
                            @endif
                        </div>
                    </div>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="lg:col-span-1">
                <!-- Emergency Contact -->
                @if($patient->emergency_contact_name)
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                        <div class="p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Emergency Contact</h3>
                            <div class="space-y-2">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Name</label>
                                    <p class="text-sm text-gray-900">{{ $patient->display_emergency_contact_name ?? 'N/A' }}</p>
                                </div>
                                @if($patient->emergency_contact_phone)
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">Phone</label>
                                        <p class="text-sm text-gray-900">{{ $patient->emergency_contact_phone }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Insurance Information -->
                @if($patient->insurance_provider)
                    <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-6">
                        <div class="p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Insurance</h3>
                            <div class="space-y-2">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700">Provider</label>
                                    <p class="text-sm text-gray-900">{{ $patient->display_insurance_provider ?? 'N/A' }}</p>
                                </div>
                                @if($patient->insurance_number)
                                    <div>
                                        <label class="block text-sm font-medium text-gray-700">Number</label>
                                        <p class="text-sm text-gray-900">{{ $patient->insurance_number }}</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endif

                <!-- Quick Stats -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Quick Stats</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-600">Medical Records:</span>
                                <span class="text-sm font-medium">{{ $patient->medicalRecords->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-600">Appointments:</span>
                                <span class="text-sm font-medium">{{ $patient->appointments->count() }}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-600">Active Medications:</span>
                                <span class="text-sm font-medium">{{ $patient->medications->filter(function($med) { return $med->is_active; })->count() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Medical Record Modal -->
    @if($showRecordModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <!-- Background overlay -->
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeRecordModal"></div>

                <!-- Center modal -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal panel -->
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                {{ $editingRecord ? 'Edit Medical Record' : 'Add Medical Record' }}
                            </h3>
                            <button wire:click="closeRecordModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="saveRecord" class="space-y-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div>
                                    <x-input-label for="record_visit_date" :value="__('Visit Date *')" />
                                    <x-text-input id="record_visit_date" class="block mt-1 w-full" type="date" wire:model="record_visit_date" required />
                                    <x-input-error :messages="$errors->get('record_visit_date')" class="mt-1" />
                                </div>

                                <div>
                                    <x-input-label for="record_visit_type" :value="__('Visit Type *')" />
                                    <select id="record_visit_type" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="record_visit_type" required>
                                        <option value="consultation">Consultation</option>
                                        <option value="follow_up">Follow-up</option>
                                        <option value="checkup">Checkup</option>
                                        <option value="emergency">Emergency</option>
                                    </select>
                                    <x-input-error :messages="$errors->get('record_visit_type')" class="mt-1" />
                                </div>
                            </div>

                            <div>
                                <x-input-label for="record_symptoms" :value="__('Symptoms')" />
                                <textarea id="record_symptoms" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="record_symptoms" placeholder="Patient symptoms and complaints"></textarea>
                                <x-input-error :messages="$errors->get('record_symptoms')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="record_diagnosis" :value="__('Diagnosis')" />
                                <textarea id="record_diagnosis" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="record_diagnosis" placeholder="Diagnosis and findings"></textarea>
                                <x-input-error :messages="$errors->get('record_diagnosis')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="record_treatment_plan" :value="__('Treatment Plan')" />
                                <textarea id="record_treatment_plan" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="record_treatment_plan" placeholder="Treatment plan and recommendations"></textarea>
                                <x-input-error :messages="$errors->get('record_treatment_plan')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="record_notes" :value="__('Notes')" />
                                <textarea id="record_notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="record_notes" placeholder="Additional notes"></textarea>
                                <x-input-error :messages="$errors->get('record_notes')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="record_follow_up_date" :value="__('Follow-up Date')" />
                                <x-text-input id="record_follow_up_date" class="block mt-1 w-full" type="date" wire:model="record_follow_up_date" />
                                <x-input-error :messages="$errors->get('record_follow_up_date')" class="mt-1" />
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeRecordModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="saveRecord" class="text-sm">
                                    <span wire:loading.remove wire:target="saveRecord">{{ $editingRecord ? 'Update Record' : 'Create Record' }}</span>
                                    <span wire:loading wire:target="saveRecord">Saving...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
