<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Patient Management</h2>
                        <p class="text-gray-600 mt-1">Manage patient records and information</p>
                    </div>
                    @if(!auth()->user()->isDoctor())
                        <button wire:click="openCreateModal" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            Add New Patient
                        </button>
                    @endif
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                <!-- Search and Filters -->
                <div class="mb-6">
                    <div class="flex flex-col sm:flex-row gap-4">
                        <div class="flex-1">
                            <input 
                                type="text" 
                                wire:model.live.debounce.300ms="search" 
                                placeholder="Search patients by name, ID, phone, or email..."
                                class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                            >
                        </div>
                    </div>
                </div>

                <!-- Patient Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer" wire:click="sortBy('patient_id')">
                                    Patient ID
                                    @if($sortBy === 'patient_id')
                                        @if($sortDirection === 'asc') ↑ @else ↓ @endif
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer" wire:click="sortBy('first_name')">
                                    Name
                                    @if($sortBy === 'first_name')
                                        @if($sortDirection === 'asc') ↑ @else ↓ @endif
                                    @endif
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Email
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Phone
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Age
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider cursor-pointer" wire:click="sortBy('created_at')">
                                    Registered
                                    @if($sortBy === 'created_at')
                                        @if($sortDirection === 'asc') ↑ @else ↓ @endif
                                    @endif
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">Actions</span>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($patients as $patient)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        {{ $patient->patient_id }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $patient->full_name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $patient->email ?? 'N/A' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $patient->phone ?? 'N/A' }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $patient->age }} years
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $patient->created_at->format('M d, Y') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex space-x-2 justify-end">
                                            @if(auth()->user()->isFrontDesk() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
                                                @php
                                                    $hasActiveVisit = $patient->active_visit !== null;
                                                @endphp
                                                @if($hasActiveVisit)
                                                    <button disabled style="background-color: #9333ea; border-color: #7e22ce;" class="cursor-not-allowed text-white font-bold px-3 py-1.5 shadow-md border-2">
                                                        Checked In
                                                    </button>
                                                @else
                                                    <button wire:click="openCreateVisitModal({{ $patient->id }})" class="bg-blue-500 hover:bg-blue-600 text-white font-medium px-3 py-1.5 transition-colors shadow-sm">
                                                        Check In
                                                    </button>
                                                @endif
                                            @endif
                                            <a href="{{ route('patients.show', $patient) }}" class="bg-indigo-500 hover:bg-indigo-600 text-white font-medium px-3 py-1.5 transition-colors shadow-sm">
                                                View
                                            </a>
                                            @if(!auth()->user()->isDoctor())
                                                <a href="{{ route('patients.show', $patient) }}" class="bg-green-500 hover:bg-green-600 text-white font-medium px-3 py-1.5 transition-colors shadow-sm">
                                                    Edit
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                                        @if($search)
                                            No patients found matching "{{ $search }}"
                                        @else
                                            No patients registered yet. 
                                            @if(!auth()->user()->isDoctor())
                                                <button wire:click="openCreateModal" class="text-indigo-600 hover:text-indigo-900 underline">Register the first patient</button>
                                            @endif
                                        @endif
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                @if($patients->hasPages())
                    <div class="mt-6">
                        {{ $patients->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Create Patient Modal -->
    @if($showCreateModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <!-- Background overlay -->
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeCreateModal"></div>

                <!-- Center modal -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal panel -->
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                Register New Patient
                            </h3>
                            <button wire:click="closeCreateModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="register" class="space-y-4">
                            <div class="grid grid-cols-1 gap-4">
                                <div>
                                    <x-input-label for="modal_first_name" :value="__('First Name *')" />
                                    <x-text-input id="modal_first_name" class="block mt-1 w-full" type="text" wire:model="first_name" required autofocus />
                                    <x-input-error :messages="$errors->get('first_name')" class="mt-1" />
                                </div>

                                <div>
                                    <x-input-label for="modal_last_name" :value="__('Last Name *')" />
                                    <x-text-input id="modal_last_name" class="block mt-1 w-full" type="text" wire:model="last_name" required />
                                    <x-input-error :messages="$errors->get('last_name')" class="mt-1" />
                                </div>

                                <div>
                                    <x-input-label for="modal_date_of_birth" :value="__('Date of Birth *')" />
                                    <x-text-input id="modal_date_of_birth" class="block mt-1 w-full" type="date" wire:model="date_of_birth" required />
                                    <x-input-error :messages="$errors->get('date_of_birth')" class="mt-1" />
                                </div>

                                <div>
                                    <x-input-label for="modal_gender" :value="__('Gender *')" />
                                    <select id="modal_gender" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="gender" required>
                                        <option value="">Select Gender</option>
                                        <option value="male">Male</option>
                                        <option value="female">Female</option>
                                        <option value="other">Other</option>
                                    </select>
                                    <x-input-error :messages="$errors->get('gender')" class="mt-1" />
                                </div>

                                <div>
                                    <x-input-label for="modal_phone" :value="__('Phone Number')" />
                                    <x-text-input id="modal_phone" class="block mt-1 w-full" type="tel" wire:model="phone" placeholder="e.g., +1-555-0123" />
                                    <x-input-error :messages="$errors->get('phone')" class="mt-1" />
                                </div>

                                <div>
                                    <x-input-label for="modal_email" :value="__('Email')" />
                                    <x-text-input id="modal_email" class="block mt-1 w-full" type="email" wire:model="email" placeholder="patient@example.com" />
                                    <x-input-error :messages="$errors->get('email')" class="mt-1" />
                                </div>
                            </div>

                            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-xs text-blue-800">
                                    <strong>Note:</strong> Additional information can be added later through the patient profile.
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeCreateModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="register" class="text-sm">
                                    <span wire:loading.remove wire:target="register">Register Patient</span>
                                    <span wire:loading wire:target="register">Registering...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <!-- Create Visit Modal -->
    @if($showCreateVisitModal && $selectedPatientForVisit)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <!-- Background overlay -->
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeCreateVisitModal"></div>

                <!-- Center modal -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal panel -->
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                Create Visit & Send to Nurse
                            </h3>
                            <button wire:click="closeCreateVisitModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <!-- Patient Info -->
                        <div class="mb-4 p-3 bg-gray-50 rounded-lg">
                            <p class="text-sm font-medium text-gray-900">{{ $selectedPatientForVisit->full_name }}</p>
                            <p class="text-xs text-gray-500">ID: {{ $selectedPatientForVisit->patient_id }}</p>
                        </div>

                        <form wire:submit.prevent="createVisit" class="space-y-4">
                            <!-- Chief Complaint - For Doctors, Developers, and CMD -->
                            @if(auth()->user()->canEnterChiefComplaint())
                                <div>
                                    <x-input-label for="chief_complaint" :value="__('Chief Complaint')" />
                                    <textarea 
                                        id="chief_complaint"
                                        wire:model="chiefComplaint"
                                        rows="3"
                                        placeholder="Brief description of patient's main complaint..."
                                        class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                    ></textarea>
                                    <x-input-error :messages="$errors->get('chiefComplaint')" class="mt-1" />
                                </div>
                            @endif

                            <!-- Visit Notes -->
                            <div>
                                <x-input-label for="visit_notes" :value="__('Visit Notes (Optional)')" />
                                <textarea 
                                    id="visit_notes"
                                    wire:model="visitNotes"
                                    rows="2"
                                    placeholder="Any additional notes..."
                                    class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                ></textarea>
                                <x-input-error :messages="$errors->get('visitNotes')" class="mt-1" />
                            </div>

                            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-xs text-blue-800">
                                    <strong>Note:</strong> After creating the visit, the patient will be automatically sent to the nursing station for vitals recording.
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click="closeCreateVisitModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="createVisit" class="text-sm">
                                    <span wire:loading.remove wire:target="createVisit">Create Visit & Send to Nurse</span>
                                    <span wire:loading wire:target="createVisit">Creating...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
