<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Nursing Station</h2>
                        <p class="text-gray-600 mt-1">Record vitals and update patient information</p>
                    </div>
                    <div class="flex items-center space-x-2">
                        <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <span class="text-sm text-gray-600">Nurse: {{ auth()->user()->name }}</span>
                    </div>
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                @if (session()->has('error'))
                    <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
                        {{ session('error') }}
                    </div>
                @endif

                <!-- Info Banner -->
                <div class="mb-6 p-4 bg-blue-50 border-l-4 border-blue-400 rounded">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-blue-700">
                                <strong>Instructions:</strong> Select a patient visit to record vitals, update medical history, and allergies. After saving, the patient will be moved to "Waiting for Doctor" status.
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Visits Waiting for Nursing -->
                <div class="mb-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Patients Waiting for Nursing</h3>
                    
                    @if($visits->count() > 0)
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            @foreach($visits as $visit)
                                <div class="border border-gray-200 rounded-lg p-4 hover:shadow-md transition-shadow cursor-pointer" wire:click="selectVisit({{ $visit->id }})">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <h4 class="font-semibold text-gray-900">{{ $visit->patient->full_name }}</h4>
                                            <p class="text-sm text-gray-500">{{ $visit->patient->patient_id }}</p>
                                        </div>
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                            {{ $visit->status_label }}
                                        </span>
                                    </div>
                                    <div class="mt-3 space-y-1 text-sm text-gray-600">
                                        <div class="flex items-center">
                                            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                            Checked in: {{ $visit->checked_in_at->format('h:i A') }}
                                        </div>
                                        @if($visit->chief_complaint)
                                            <div class="flex items-start mt-2">
                                                <svg class="w-4 h-4 mr-2 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                </svg>
                                                <span class="text-xs">{{ strlen($visit->chief_complaint) > 60 ? substr($visit->chief_complaint, 0, 60) . '...' : $visit->chief_complaint }}</span>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="mt-3 pt-3 border-t border-gray-200">
                                        <button class="w-full bg-blue-500 hover:bg-blue-600 text-white text-sm font-medium py-2 px-4 rounded">
                                            Record Vitals
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-12 bg-gray-50 rounded-lg">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <h3 class="mt-2 text-sm font-medium text-gray-900">No patients waiting</h3>
                            <p class="mt-1 text-sm text-gray-500">All patients have been processed or are waiting for other departments.</p>
                        </div>
                    @endif
                </div>

                <!-- Pagination -->
                @if($visits->hasPages())
                    <div class="mt-4">
                        {{ $visits->links() }}
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- Vitals Recording Modal -->
    @if($showVitalsModal && $selectedVisit && $selectedPatient)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <!-- Background overlay -->
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeVitalsModal"></div>

                <!-- Center modal -->
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

                <!-- Modal panel -->
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-4xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    Record Vitals & Update Patient Information
                                </h3>
                                <p class="text-sm text-gray-500 mt-1">
                                    {{ $selectedPatient->full_name }} ({{ $selectedPatient->patient_id }}) • Visit: {{ $selectedVisit->visit_number }}
                                </p>
                            </div>
                            <button wire:click="closeVitalsModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="saveVitals" class="space-y-6">
                            <!-- Vital Signs Section -->
                            <div class="border-t border-gray-200 pt-4">
                                <h4 class="text-md font-semibold text-gray-900 mb-4">Vital Signs</h4>
                                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                                    <div>
                                        <x-input-label for="blood_pressure" :value="__('Blood Pressure')" />
                                        <x-text-input id="blood_pressure" class="block mt-1 w-full" type="text" wire:model="blood_pressure" placeholder="e.g., 120/80" />
                                        <x-input-error :messages="$errors->get('blood_pressure')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="temperature" :value="__('Temperature (°F)')" />
                                        <x-text-input id="temperature" class="block mt-1 w-full" type="number" step="0.1" wire:model="temperature" placeholder="e.g., 98.6" />
                                        <x-input-error :messages="$errors->get('temperature')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="pulse" :value="__('Pulse (BPM)')" />
                                        <x-text-input id="pulse" class="block mt-1 w-full" type="number" wire:model="pulse" placeholder="e.g., 72" />
                                        <x-input-error :messages="$errors->get('pulse')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="height" :value="__('Height (cm)')" />
                                        <x-text-input id="height" class="block mt-1 w-full" type="number" step="0.1" wire:model="height" placeholder="e.g., 170" />
                                        <x-input-error :messages="$errors->get('height')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="weight" :value="__('Weight (kg)')" />
                                        <x-text-input id="weight" class="block mt-1 w-full" type="number" step="0.1" wire:model="weight" placeholder="e.g., 70" />
                                        <x-input-error :messages="$errors->get('weight')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="respiratory_rate" :value="__('Respiratory Rate')" />
                                        <x-text-input id="respiratory_rate" class="block mt-1 w-full" type="number" wire:model="respiratory_rate" placeholder="e.g., 16" />
                                        <x-input-error :messages="$errors->get('respiratory_rate')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="oxygen_saturation" :value="__('Oxygen Saturation (%)')" />
                                        <x-text-input id="oxygen_saturation" class="block mt-1 w-full" type="number" wire:model="oxygen_saturation" placeholder="e.g., 98" />
                                        <x-input-error :messages="$errors->get('oxygen_saturation')" class="mt-1" />
                                    </div>
                                </div>
                            </div>

                            <!-- Medical History & Allergies Section (Longitudinal Record) -->
                            <div class="border-t border-gray-200 pt-4">
                                <h4 class="text-md font-semibold text-gray-900 mb-4">Medical History & Allergies</h4>
                                <p class="text-xs text-gray-500 mb-4">These updates will be saved to the patient's permanent record.</p>
                                
                                <div class="space-y-4">
                                    <div>
                                        <x-input-label for="medical_history" :value="__('Medical History')" />
                                        <textarea id="medical_history" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="4" wire:model="medical_history" placeholder="Previous medical conditions, surgeries, chronic diseases, etc."></textarea>
                                        <x-input-error :messages="$errors->get('medical_history')" class="mt-1" />
                                    </div>

                                    <div>
                                        <x-input-label for="allergies" :value="__('Allergies')" />
                                        <textarea id="allergies" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="allergies" placeholder="Known allergies, medication reactions, etc."></textarea>
                                        <x-input-error :messages="$errors->get('allergies')" class="mt-1" />
                                        @if($selectedPatient->allergies)
                                            <p class="mt-1 text-xs text-red-600 font-medium">⚠ Current allergies: {{ $selectedPatient->allergies }}</p>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-xs text-blue-800">
                                    <strong>Note:</strong> After saving, the patient will be moved to "Waiting for Doctor" status and the doctor will be able to see all recorded vitals and updated information.
                                </p>
                            </div>

                            <div class="flex justify-end space-x-3 pt-4 border-t border-gray-200">
                                <button type="button" wire:click="closeVitalsModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <x-primary-button wire:loading.attr="disabled" wire:target="saveVitals" class="text-sm">
                                    <span wire:loading.remove wire:target="saveVitals">Save Vitals & Update Status</span>
                                    <span wire:loading wire:target="saveVitals">Saving...</span>
                                </x-primary-button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
