<?php

use App\Livewire\Actions\Logout;
use Livewire\Volt\Component;

new class extends Component
{
    /**
     * Log the current user out of the application.
     */
    public function logout(Logout $logout): void
    {
        $logout();

        $this->redirect('/', navigate: true);
    }
}; ?>

<nav x-data="{ open: false }" class="bg-white border-b border-gray-100">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('hospital.dashboard') }}" wire:navigate>
                        <x-application-logo class="block h-9 w-auto fill-current text-gray-800" />
                    </a>
                </div>

                <!-- Navigation Links -->
                @php
                    use App\Services\NavigationService;
                    $menuItems = NavigationService::getMenuItems();
                @endphp
                
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    @foreach($menuItems as $item)
                        @if($item['type'] === 'link')
                            {{-- Single Link Item --}}
                            <x-nav-link 
                                :href="route($item['route'])" 
                                :active="request()->routeIs($item['routePattern'])" 
                                wire:navigate>
                                {{ __($item['label']) }}
                            </x-nav-link>
                        
                        @elseif($item['type'] === 'dropdown')
                            {{-- Dropdown Menu Item --}}
                            <x-nav-dropdown align="left" width="48" :active="App\Services\NavigationService::isDropdownActive($item['items'])">
                                <x-slot name="trigger">
                                    {{ __($item['label']) }}
                                    <svg class="ms-1 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                    </svg>
                                </x-slot>

                                <x-slot name="content">
                                    @foreach($item['items'] as $subItem)
                                        <x-dropdown-link 
                                            :href="route($subItem['route'])" 
                                            wire:navigate
                                            class="{{ request()->routeIs($subItem['routePattern']) ? 'bg-gray-100' : '' }}">
                                            {{ __($subItem['label']) }}
                                        </x-dropdown-link>
                                    @endforeach
                                </x-slot>
                            </x-dropdown>
                        @endif
                    @endforeach
                </div>
            </div>

            <!-- Settings Dropdown -->
            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 bg-white hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
                            <div class="flex flex-col items-end">
                                <div x-data="{{ json_encode(['name' => auth()->user()->name]) }}" x-text="name" x-on:profile-updated.window="name = $event.detail.name"></div>
                                <span class="text-xs text-gray-400 capitalize">{{ auth()->user()->role ?? 'staff' }}</span>
                            </div>

                            <div class="ms-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile')" wire:navigate>
                            {{ __('Profile') }}
                        </x-dropdown-link>

                        <!-- Authentication -->
                        <button wire:click="logout" class="w-full text-start">
                            <x-dropdown-link>
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </button>
                    </x-slot>
                </x-dropdown>
            </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-gray-500 hover:bg-gray-100 focus:outline-none focus:bg-gray-100 focus:text-gray-500 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
            <div class="pt-2 pb-3 space-y-1">
                @foreach($menuItems as $item)
                    @if($item['type'] === 'link')
                        {{-- Single Link Item --}}
                        <x-responsive-nav-link 
                            :href="route($item['route'])" 
                            :active="request()->routeIs($item['routePattern'])" 
                            wire:navigate>
                            {{ __($item['label']) }}
                        </x-responsive-nav-link>
                    
                    @elseif($item['type'] === 'dropdown')
                        {{-- Dropdown Items Rendered as Flat Links for Mobile --}}
                        <div class="px-4 pt-2">
                            <div class="text-xs font-semibold text-gray-400 uppercase tracking-wider">
                                {{ __($item['label']) }}
                            </div>
                        </div>
                        @foreach($item['items'] as $subItem)
                            <x-responsive-nav-link 
                                :href="route($subItem['route'])" 
                                :active="request()->routeIs($subItem['routePattern'])" 
                                wire:navigate
                                class="pl-8">
                                {{ __($subItem['label']) }}
                            </x-responsive-nav-link>
                        @endforeach
                    @endif
                @endforeach
            </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-gray-200">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800" x-data="{{ json_encode(['name' => auth()->user()->name]) }}" x-text="name" x-on:profile-updated.window="name = $event.detail.name"></div>
                <div class="font-medium text-sm text-gray-500">{{ auth()->user()->email }}</div>
                <div class="font-medium text-xs text-gray-400 mt-1 capitalize">{{ auth()->user()->role ?? 'staff' }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile')" wire:navigate>
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <!-- Authentication -->
                <button wire:click="logout" class="w-full text-start">
                    <x-responsive-nav-link>
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </button>
            </div>
        </div>
    </div>
</nav>
