<div>
    <div class="max-w-7xl mx-auto py-6 sm:px-6 lg:px-8">
        <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div class="p-6 text-gray-900">
                <div class="flex justify-between items-center mb-6">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">Laboratory Workflow</h2>
                        <p class="text-gray-600 mt-1">
                            @if($canModify)
                                Process lab requests and record test results
                            @else
                                View lab requests and test results (Read-Only)
                            @endif
                        </p>
                    </div>
                    <div class="flex items-center space-x-2">
                        <svg class="w-6 h-6 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
                        </svg>
                        <span class="text-sm text-gray-600">{{ auth()->user()->name }}</span>
                        @if(!$canModify)
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Read-Only</span>
                        @endif
                    </div>
                </div>

                @if (session()->has('message'))
                    <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                        {{ session('message') }}
                    </div>
                @endif

                <!-- Filters -->
                <div class="mb-6">
                    <select wire:model.live="statusFilter" class="px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                        <option value="pending">Pending Requests</option>
                        <option value="in_progress">In Progress</option>
                        <option value="completed">Completed</option>
                    </select>
                </div>

                <!-- Lab Requests Table -->
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Request ID
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Patient
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Test Name
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Requested By
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Requested At
                                </th>
                                <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Status
                                </th>
                                <th scope="col" class="relative px-6 py-3">
                                    <span class="sr-only">Actions</span>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @forelse($labRequests as $request)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                                        #{{ $request->id }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <div>
                                            <div class="font-medium">{{ $request->patient->full_name }}</div>
                                            <div class="text-gray-500 text-xs">{{ $request->patient->patient_id }}</div>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900">
                                        <div class="font-medium">{{ ucwords(strtolower($request->test_name)) }}</div>
                                        <div class="text-xs text-gray-500">{{ ucwords(str_replace('_', ' ', strtolower($request->test_type))) }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        Dr. {{ ucwords(strtolower($request->requestedBy->name)) }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        {{ $request->requested_at->format('M d, Y h:i A') }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-{{ $request->status_color }}-100 text-{{ $request->status_color }}-800">
                                            {{ ucfirst(str_replace('_', ' ', $request->status)) }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                        <div class="flex space-x-2">
                                            @if($canModify)
                                                @if($request->status === 'pending')
                                                    <button wire:click="markInProgress({{ $request->id }})" class="text-blue-600 hover:text-blue-900">
                                                        Start
                                                    </button>
                                                @endif
                                                @if($request->status === 'in_progress' || $request->status === 'pending')
                                                    <button wire:click="selectRequest({{ $request->id }})" class="text-green-600 hover:text-green-900">
                                                        Record Results
                                                    </button>
                                                @endif
                                                @if($request->status === 'completed')
                                                    <button wire:click="selectRequest({{ $request->id }})" class="text-indigo-600 hover:text-indigo-900">
                                                        View Results
                                                    </button>
                                                @endif
                                                @if($request->status !== 'completed' && $request->status !== 'cancelled')
                                                    <button wire:click="cancelRequest({{ $request->id }})" 
                                                            wire:confirm="Are you sure you want to cancel this lab request?"
                                                            class="text-red-600 hover:text-red-900">
                                                        Cancel
                                                    </button>
                                                @endif
                                            @else
                                                {{-- Read-only mode: Only show View Results button --}}
                                                <button wire:click="selectRequest({{ $request->id }})" class="text-indigo-600 hover:text-indigo-900">
                                                    View Results
                                                </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="px-6 py-4 text-center text-sm text-gray-500">
                                        No lab requests found.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-4">
                    {{ $labRequests->links() }}
                </div>
            </div>
        </div>
    </div>

    <!-- Results Recording Modal -->
    @if($showResultModal && $selectedRequest)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click="closeResultModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                    @if($canModify)
                                        Record Lab Results
                                    @else
                                        View Lab Results
                                    @endif
                                </h3>
                                <p class="text-sm text-gray-500 mt-1">
                                    {{ ucwords(strtolower($selectedRequest->test_name)) }} • {{ $selectedRequest->patient->full_name }}
                                </p>
                            </div>
                            <button wire:click="closeResultModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        @if($canModify)
                            <form wire:submit.prevent="saveResults" class="space-y-4">
                                <div>
                                    <x-input-label for="results" :value="__('Test Results *')" />
                                    <textarea id="results" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="6" wire:model="results" placeholder="Enter detailed test results..." required></textarea>
                                    <x-input-error :messages="$errors->get('results')" class="mt-1" />
                                </div>

                                <div>
                                    <x-input-label for="notes" :value="__('Notes (Optional)')" />
                                    <textarea id="notes" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="notes" placeholder="Additional notes or observations..."></textarea>
                                    <x-input-error :messages="$errors->get('notes')" class="mt-1" />
                                </div>

                                @if($selectedRequest->clinical_indication)
                                    <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                        <p class="text-xs text-blue-800">
                                            <strong>Clinical Indication:</strong> {{ ucwords(strtolower($selectedRequest->clinical_indication)) }}
                                        </p>
                                    </div>
                                @endif

                                <div class="flex justify-end space-x-3 pt-4">
                                    <button type="button" wire:click="closeResultModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                        Cancel
                                    </button>
                                    <x-primary-button wire:loading.attr="disabled" wire:target="saveResults" class="text-sm">
                                        <span wire:loading.remove wire:target="saveResults">Save Results</span>
                                        <span wire:loading wire:target="saveResults">Saving...</span>
                                    </x-primary-button>
                                </div>
                            </form>
                        @else
                            {{-- Read-only view for doctors --}}
                            <div class="space-y-4">
                                <div>
                                    <x-input-label for="results" :value="__('Test Results')" />
                                    <div class="mt-1 p-3 bg-gray-50 border border-gray-300 rounded-md text-sm text-gray-900 whitespace-pre-wrap">
                                        {{ $selectedRequest->results ?? 'No results recorded yet.' }}
                                    </div>
                                </div>

                                @if($selectedRequest->notes)
                                    <div>
                                        <x-input-label for="notes" :value="__('Notes')" />
                                        <div class="mt-1 p-3 bg-gray-50 border border-gray-300 rounded-md text-sm text-gray-900 whitespace-pre-wrap">
                                            {{ $selectedRequest->notes }}
                                        </div>
                                    </div>
                                @endif

                                @if($selectedRequest->clinical_indication)
                                    <div class="p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                        <p class="text-xs text-blue-800">
                                            <strong>Clinical Indication:</strong> {{ ucwords(strtolower($selectedRequest->clinical_indication)) }}
                                        </p>
                                    </div>
                                @endif

                                <div class="flex justify-end space-x-3 pt-4">
                                    <button type="button" wire:click="closeResultModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                        Close
                                    </button>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
