<div>
    @if($showModal)
        <div class="fixed inset-0 z-50 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true" style="z-index: 10001;">
            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <div class="fixed inset-0 bg-gray-500 bg-opacity-50 transition-opacity" wire:click.stop="closeModal"></div>
                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>
                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                    <div class="bg-white px-4 pt-5 pb-4 sm:p-6 sm:pb-4">
                        <div class="flex justify-between items-center mb-4">
                            <h3 class="text-lg font-semibold text-gray-900" id="modal-title">
                                Request Lab Test
                            </h3>
                            <button type="button" wire:click.stop="closeModal" class="text-gray-400 hover:text-gray-500">
                                <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>

                        <form wire:submit.prevent="save" class="space-y-4" onclick="event.stopPropagation()">
                            <div>
                                <x-input-label for="test_type" :value="__('Test Type *')" />
                                <select id="test_type" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="test_type" required>
                                    <option value="blood_test">Blood Test</option>
                                    <option value="urine_test">Urine Test</option>
                                    <option value="imaging">Imaging</option>
                                    <option value="other">Other</option>
                                </select>
                                <x-input-error :messages="$errors->get('test_type')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="test_name" :value="__('Test Name *')" />
                                <select id="test_name" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" wire:model="test_name" required>
                                    <option value="">Select a test...</option>
                                    @if(isset($commonTests[$test_type]))
                                        @foreach($commonTests[$test_type] as $test)
                                            <option value="{{ $test }}">{{ $test }}</option>
                                        @endforeach
                                    @endif
                                </select>
                                @if($test_type === 'other' || $test_name === 'Other')
                                    <x-text-input id="test_name_custom" class="block mt-2 w-full" type="text" wire:model="test_name" placeholder="Enter test name..." />
                                @endif
                                <x-input-error :messages="$errors->get('test_name')" class="mt-1" />
                            </div>

                            <div>
                                <x-input-label for="clinical_indication" :value="__('Clinical Indication')" />
                                <textarea id="clinical_indication" class="block mt-1 w-full border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm" rows="3" wire:model="clinical_indication" placeholder="Why is this test needed?"></textarea>
                                <x-input-error :messages="$errors->get('clinical_indication')" class="mt-1" />
                            </div>

                            <div class="flex justify-end space-x-3 pt-4">
                                <button type="button" wire:click.stop="closeModal" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2 px-4 rounded text-sm">
                                    Cancel
                                </button>
                                <button type="submit" wire:loading.attr="disabled" wire:target="save" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:border-indigo-900 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150 text-sm">
                                    <span wire:loading.remove wire:target="save">Request Test</span>
                                    <span wire:loading wire:target="save">Requesting...</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
