<div>
    <div class="py-6">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6">
                    <!-- Header -->
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-bold text-gray-900">Appointments Management</h2>
                        <div class="flex items-center gap-3">
                            <!-- View Toggle -->
                            <div class="flex bg-gray-100 rounded-lg p-1">
                                <button wire:click="switchView('list')" class="px-4 py-2 rounded-md text-sm font-medium transition-colors {{ $viewMode === 'list' ? 'bg-white text-blue-600 shadow-sm' : 'text-gray-600 hover:text-gray-900' }}">
                                    <svg class="w-5 h-5 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 10h16M4 14h16M4 18h16"></path>
                                    </svg>
                                    List
                                </button>
                                <button wire:click="switchView('calendar')" class="px-4 py-2 rounded-md text-sm font-medium transition-colors {{ $viewMode === 'calendar' ? 'bg-white text-blue-600 shadow-sm' : 'text-gray-600 hover:text-gray-900' }}">
                                    <svg class="w-5 h-5 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                    </svg>
                                    Calendar
                                </button>
                            </div>
                            <button wire:click="openCreateModal" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg flex items-center gap-2">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                </svg>
                                New Appointment
                            </button>
                        </div>
                    </div>

                    @if (session()->has('message'))
                        <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
                            {{ session('message') }}
                        </div>
                    @endif

                    <!-- Filters -->
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
                        <div>
                            <x-text-input wire:model.live="search" type="text" placeholder="Search patients or doctors..." class="w-full" />
                        </div>
                        <div>
                            <select wire:model.live="statusFilter" class="block w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">All Statuses</option>
                                <option value="scheduled">Scheduled</option>
                                <option value="confirmed">Confirmed</option>
                                <option value="in_progress">In Progress</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                                <option value="no_show">No Show</option>
                            </select>
                        </div>
                        <div>
                            <select wire:model.live="typeFilter" class="block w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">All Types</option>
                                <option value="consultation">Consultation</option>
                                <option value="follow_up">Follow Up</option>
                                <option value="checkup">Checkup</option>
                                <option value="emergency">Emergency</option>
                            </select>
                        </div>
                        <div>
                            <x-text-input wire:model.live="dateFilter" type="date" class="w-full" />
                        </div>
                    </div>

                    @if($viewMode === 'calendar')
                        <!-- Calendar View -->
                        <div class="bg-white rounded-lg border border-gray-200">
                            <!-- Calendar Header -->
                            <div class="flex items-center justify-between p-4 border-b border-gray-200">
                                <button wire:click="previousMonth" class="p-2 hover:bg-gray-100 rounded-lg">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                                    </svg>
                                </button>
                                <div class="flex items-center gap-3">
                                    <h3 class="text-xl font-semibold text-gray-900">{{ $calendarMonthName }}</h3>
                                    <button wire:click="goToToday" class="px-3 py-1 text-sm bg-blue-100 text-blue-700 rounded-md hover:bg-blue-200">
                                        Today
                                    </button>
                                </div>
                                <button wire:click="nextMonth" class="p-2 hover:bg-gray-100 rounded-lg">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </button>
                            </div>
                            
                            <!-- Calendar Grid -->
                            <div class="p-4">
                                <!-- Day Headers -->
                                <div class="grid grid-cols-7 gap-1 mb-2">
                                    @foreach(['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'] as $day)
                                        <div class="text-center text-sm font-semibold text-gray-600 py-2">{{ $day }}</div>
                                    @endforeach
                                </div>
                                
                                <!-- Calendar Days -->
                                <div class="grid grid-cols-7 gap-1">
                                    @foreach($calendarDays as $dayData)
                                        @if($dayData === null)
                                            <div class="aspect-square bg-gray-50 rounded-lg"></div>
                                        @else
                                            @php
                                                $day = $dayData['day'];
                                                $date = $dayData['date'];
                                                $dayAppointments = $dayData['appointments'];
                                                $isToday = $date->isToday();
                                                $isPast = $date->isPast() && !$date->isToday();
                                            @endphp
                                            <div class="aspect-square border border-gray-200 rounded-lg p-2 {{ $isToday ? 'bg-blue-50 border-blue-300' : ($isPast ? 'bg-gray-50' : 'bg-white hover:bg-gray-50') }} transition-colors cursor-pointer" 
                                                 @if($dayAppointments->count() > 0) wire:click="$dispatch('open-appointment-day', { date: '{{ $date->format('Y-m-d') }}' })" @endif>
                                                <div class="flex justify-between items-start mb-1">
                                                    <span class="text-sm font-medium {{ $isToday ? 'text-blue-700' : 'text-gray-700' }}">{{ $day }}</span>
                                                    @if($dayAppointments->count() > 0)
                                                        <span class="text-xs bg-blue-600 text-white rounded-full px-1.5 py-0.5 min-w-[20px] text-center">{{ $dayAppointments->count() }}</span>
                                                    @endif
                                                </div>
                                                <div class="space-y-1 mt-1 overflow-hidden">
                                                    @foreach($dayAppointments->take(3) as $apt)
                                                        <div class="text-xs p-1 rounded truncate 
                                                            @if($apt->status === 'completed') bg-green-100 text-green-800
                                                            @elseif($apt->status === 'cancelled' || $apt->status === 'no_show') bg-red-100 text-red-800
                                                            @elseif($apt->status === 'in_progress') bg-purple-100 text-purple-800
                                                            @elseif($apt->status === 'confirmed') bg-blue-100 text-blue-800
                                                            @else bg-yellow-100 text-yellow-800
                                                            @endif" 
                                                            wire:click.stop="openEditModal({{ $apt->id }})"
                                                            title="{{ $apt->patient_name }} - {{ \Carbon\Carbon::parse($apt->appointment_time)->format('h:i A') }}">
                                                            {{ \Carbon\Carbon::parse($apt->appointment_time)->format('h:i') }} - {{ $apt->isGuest() ? explode(' ', $apt->guest_name)[0] : ($apt->patient ? $apt->patient->first_name : 'N/A') }}
                                                        </div>
                                                    @endforeach
                                                    @if($dayAppointments->count() > 3)
                                                        <div class="text-xs text-gray-500 text-center">+{{ $dayAppointments->count() - 3 }} more</div>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @else
                        <!-- List View -->
                        <!-- Appointments Table -->
                        <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Patient</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Doctor</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date & Time</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Duration</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Type</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($appointments as $appointment)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <div class="text-sm font-medium text-gray-900">{{ $appointment->patient_name }}</div>
                                            @if($appointment->isGuest())
                                                <div class="text-xs text-gray-500">
                                                    <span class="px-2 py-0.5 bg-orange-100 text-orange-800 rounded-full">Guest</span>
                                                    @if($appointment->guest_phone)
                                                        <span class="ml-2">{{ $appointment->guest_phone }}</span>
                                                    @endif
                                                </div>
                                            @elseif($appointment->patient)
                                                <div class="text-sm text-gray-500">{{ $appointment->patient->patient_id }}</div>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ ucwords(strtolower($appointment->doctor->name)) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                            {{ $appointment->appointment_date->format('M d, Y') }}
                                            <div class="text-gray-500">{{ \Carbon\Carbon::parse($appointment->appointment_time)->format('h:i A') }}</div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">{{ $appointment->duration }} min</td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800">
                                                {{ ucfirst(str_replace('_', ' ', $appointment->type)) }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap">
                                            <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                                @if($appointment->status === 'completed') bg-green-100 text-green-800
                                                @elseif($appointment->status === 'cancelled' || $appointment->status === 'no_show') bg-red-100 text-red-800
                                                @elseif($appointment->status === 'in_progress') bg-purple-100 text-purple-800
                                                @elseif($appointment->status === 'confirmed') bg-blue-100 text-blue-800
                                                @else bg-yellow-100 text-yellow-800
                                                @endif">
                                                {{ ucfirst(str_replace('_', ' ', $appointment->status)) }}
                                            </span>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                            <div class="flex items-center gap-2">
                                                @if(auth()->user()->isFrontDesk() && $appointment->status === 'scheduled' && !$appointment->checked_in_at)
                                                    <button wire:click="checkIn({{ $appointment->id }})" 
                                                        class="text-green-600 hover:text-green-900 font-medium" 
                                                        title="Check In Appointment">
                                                        Check In
                                                    </button>
                                                @endif
                                                <button wire:click="openEditModal({{ $appointment->id }})" class="text-indigo-600 hover:text-indigo-900">Edit</button>
                                                <button wire:click="delete({{ $appointment->id }})" 
                                                    wire:confirm="Are you sure you want to delete this appointment?" 
                                                    class="text-red-600 hover:text-red-900">Delete</button>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="px-6 py-4 text-center text-gray-500">No appointments found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                        <div class="mt-4">
                            {{ $appointments->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Create/Edit Modal -->
    @if($showCreateModal || $showEditModal)
        <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
            <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
                <div class="mt-3">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">
                        {{ $editingAppointment ? 'Edit Appointment' : 'New Appointment' }}
                    </h3>
                    
                    <form wire:submit.prevent="save" class="space-y-4">
                        <!-- Guest/Walk-in Toggle -->
                        <div class="flex items-center">
                            <input type="checkbox" wire:model.live="is_guest" id="is_guest" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="is_guest" class="ml-2 block text-sm text-gray-900">
                                Guest/Walk-in Patient (Not a regular patient)
                            </label>
                        </div>

                        @if($is_guest)
                            <!-- Guest Patient Fields -->
                            <div>
                                <x-input-label for="guest_name" value="Guest Name *" />
                                <x-text-input wire:model="guest_name" id="guest_name" type="text" class="block mt-1 w-full" placeholder="Enter guest name" />
                                <x-input-error :messages="$errors->get('guest_name')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="guest_phone" value="Guest Phone *" />
                                <x-text-input wire:model="guest_phone" id="guest_phone" type="text" class="block mt-1 w-full" placeholder="Enter phone number" />
                                <x-input-error :messages="$errors->get('guest_phone')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="guest_email" value="Guest Email (Optional)" />
                                <x-text-input wire:model="guest_email" id="guest_email" type="email" class="block mt-1 w-full" placeholder="Enter email address" />
                                <x-input-error :messages="$errors->get('guest_email')" class="mt-2" />
                            </div>
                        @else
                            <!-- Regular Patient Selection -->
                            <div>
                                <x-input-label for="patient_id" value="Patient *" />
                                <div class="relative">
                                    <input 
                                        type="text" 
                                        id="patient_search"
                                        wire:model.live.debounce.300ms="patientSearch"
                                        wire:keyup="searchPatients"
                                        placeholder="Search by name, ID, phone, or email..."
                                        class="block w-full mt-1 border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm"
                                        autocomplete="off"
                                    />
                                    @if(count($searchResults) > 0 && !$patient_id)
                                        <div class="absolute z-10 w-full mt-1 bg-white border border-gray-300 rounded-md shadow-lg max-h-60 overflow-auto">
                                            @foreach($searchResults as $patient)
                                                <button 
                                                    type="button"
                                                    wire:click="selectPatient({{ $patient->id }})"
                                                    class="w-full text-left px-4 py-2 hover:bg-gray-100 focus:bg-gray-100 focus:outline-none"
                                                >
                                                    <div class="font-medium">{{ $patient->full_name }}</div>
                                                    <div class="text-sm text-gray-500">{{ $patient->patient_id }} • {{ $patient->phone ?? 'N/A' }}</div>
                                                </button>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                                @if($patient_id)
                                    <div class="mt-2 p-2 bg-green-50 border border-green-200 rounded">
                                        <span class="text-sm text-green-800">✓ Patient selected</span>
                                    </div>
                                @endif
                                <input type="hidden" wire:model="patient_id" />
                                <x-input-error :messages="$errors->get('patient_id')" class="mt-2" />
                            </div>
                        @endif

                        <div>
                            <x-input-label for="doctor_id" value="Doctor" />
                            <select wire:model="doctor_id" id="doctor_id" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                <option value="">Select Doctor</option>
                                @foreach($doctors as $doctor)
                                    <option value="{{ $doctor->id }}">{{ ucwords(strtolower($doctor->name)) }}</option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('doctor_id')" class="mt-2" />
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <x-input-label for="appointment_date" value="Date" />
                                <x-text-input wire:model="appointment_date" id="appointment_date" type="date" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('appointment_date')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="appointment_time" value="Time" />
                                <x-text-input wire:model="appointment_time" id="appointment_time" type="time" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('appointment_time')" class="mt-2" />
                            </div>
                        </div>

                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <x-input-label for="duration" value="Duration (minutes)" />
                                <x-text-input wire:model="duration" id="duration" type="number" min="15" max="480" step="15" class="block mt-1 w-full" />
                                <x-input-error :messages="$errors->get('duration')" class="mt-2" />
                            </div>
                            <div>
                                <x-input-label for="type" value="Type" />
                                <select wire:model="type" id="type" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                    <option value="consultation">Consultation</option>
                                    <option value="follow_up">Follow Up</option>
                                    <option value="checkup">Checkup</option>
                                    <option value="emergency">Emergency</option>
                                </select>
                                <x-input-error :messages="$errors->get('type')" class="mt-2" />
                            </div>
                        </div>

                        <div>
                            <x-input-label for="status" value="Status" />
                            <select wire:model="status" id="status" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm">
                                <option value="scheduled">Scheduled</option>
                                <option value="confirmed">Confirmed</option>
                                <option value="in_progress">In Progress</option>
                                <option value="completed">Completed</option>
                                <option value="cancelled">Cancelled</option>
                                <option value="no_show">No Show</option>
                            </select>
                            <x-input-error :messages="$errors->get('status')" class="mt-2" />
                        </div>

                        <div>
                            <x-input-label for="reason" value="Reason" />
                            <textarea wire:model="reason" id="reason" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" rows="2"></textarea>
                            <x-input-error :messages="$errors->get('reason')" class="mt-2" />
                        </div>

                        <div>
                            <x-input-label for="notes" value="Notes" />
                            <textarea wire:model="notes" id="notes" class="block mt-1 w-full border-gray-300 rounded-md shadow-sm" rows="3"></textarea>
                            <x-input-error :messages="$errors->get('notes')" class="mt-2" />
                        </div>

                        <div class="flex justify-end space-x-3 pt-4">
                            <button type="button" wire:click="closeModals" class="px-4 py-2 bg-gray-300 text-gray-700 rounded-lg hover:bg-gray-400">
                                Cancel
                            </button>
                            <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                                {{ $editingAppointment ? 'Update' : 'Create' }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endif
</div>

