<div>
    <div class="max-w-4xl mx-auto">
        <div class="bg-white shadow-sm sm:rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-medium text-gray-900 flex items-center">
                    <svg class="w-5 h-5 text-blue-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    AI Drug Interaction Checker
                </h3>
                <p class="text-sm text-gray-600 mt-1">Select multiple drugs to check for potential interactions using AI analysis</p>
            </div>

            <div class="p-6">
                <!-- Drug Search -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">Search for Drugs</label>
                    <input 
                        type="text" 
                        wire:model.live="search" 
                        placeholder="Search by drug name or generic name..."
                        class="block w-full border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                    >
                </div>

                <!-- Available Drugs -->
                @if($availableDrugs->count() > 0)
                    <div class="mb-6">
                        <h4 class="text-sm font-medium text-gray-700 mb-3">Available Drugs</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                            @foreach($availableDrugs as $drug)
                                <div class="border border-gray-200 rounded-lg p-3 hover:bg-gray-50 cursor-pointer"
                                     wire:click="addDrug({{ $drug->id }})">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <h5 class="font-medium text-gray-900">{{ ucwords(strtolower($drug->name)) }}</h5>
                                            <p class="text-sm text-gray-600">{{ ucwords(strtolower($drug->generic_name)) }}</p>
                                            <p class="text-xs text-gray-500">{{ ucwords(strtolower($drug->category ?? '')) }}</p>
                                        </div>
                                        <button type="button" class="text-blue-500 hover:text-blue-700">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                                            </svg>
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Selected Drugs -->
                @if(count($selectedDrugs) > 0)
                    <div class="mb-6">
                        <h4 class="text-sm font-medium text-gray-700 mb-3">Selected Drugs ({{ count($selectedDrugs) }})</h4>
                        <div class="space-y-2">
                            @foreach($this->selectedDrugsModels as $drug)
                                <div class="flex items-center justify-between bg-blue-50 border border-blue-200 rounded-lg p-3">
                                    <div>
                                        <h5 class="font-medium text-gray-900">{{ ucwords(strtolower($drug->name)) }}</h5>
                                        <p class="text-sm text-gray-600">{{ ucwords(strtolower($drug->generic_name)) }}</p>
                                    </div>
                                    <button type="button" 
                                            wire:click="removeDrug({{ $drug->id }})"
                                            class="text-red-500 hover:text-red-700">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                        </svg>
                                    </button>
                                </div>
                            @endforeach
                        </div>

                        <div class="mt-4">
                            <button type="button"
                                    wire:click="checkInteractions"
                                    wire:loading.attr="disabled"
                                    class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded disabled:opacity-50">
                                <span wire:loading.remove wire:target="checkInteractions">
                                    Check Interactions with AI
                                </span>
                                <span wire:loading wire:target="checkInteractions">
                                    <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-white inline" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                    </svg>
                                    Analyzing...
                                </span>
                            </button>
                        </div>
                    </div>
                @endif

                <!-- Interaction Results -->
                @if($interactionResults)
                    <div class="border-t border-gray-200 pt-6">
                        <div class="flex items-center mb-4">
                            <h4 class="text-lg font-medium text-gray-900">AI Analysis Results</h4>
                            @if($interactionResults['ai_generated'])
                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    AI Generated
                                </span>
                            @else
                                <span class="ml-2 inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                    Fallback Analysis
                                </span>
                            @endif
                        </div>

                        <!-- Risk Level -->
                        <div class="mb-4">
                            <div class="flex items-center">
                                <span class="text-sm font-medium text-gray-700 mr-2">Risk Level:</span>
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                                    @if($this->riskLevelColor === 'green') bg-green-100 text-green-800
                                    @elseif($this->riskLevelColor === 'yellow') bg-yellow-100 text-yellow-800
                                    @elseif($this->riskLevelColor === 'orange') bg-orange-100 text-orange-800
                                    @elseif($this->riskLevelColor === 'red') bg-red-100 text-red-800
                                    @else bg-gray-100 text-gray-800 @endif">
                                    {{ ucfirst($interactionResults['risk_level']) }}
                                </span>
                            </div>
                        </div>

                        <!-- Interactions -->
                        @if(!empty($interactionResults['interactions']))
                            <div class="mb-4">
                                <h5 class="text-sm font-medium text-gray-700 mb-2">Identified Interactions:</h5>
                                <ul class="list-disc list-inside space-y-1 text-sm text-gray-600">
                                    @foreach($interactionResults['interactions'] as $interaction)
                                        <li>
                                            @if(is_array($interaction))
                                                <strong>{{ $interaction['drug'] ?? 'Unknown' }}:</strong> {{ $interaction['interaction'] ?? 'No details available' }}
                                            @else
                                                {{ $interaction }}
                                            @endif
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <!-- Clinical Significance -->
                        @if(!empty($interactionResults['clinical_significance']))
                            <div class="mb-4">
                                <h5 class="text-sm font-medium text-gray-700 mb-2">Clinical Significance:</h5>
                                <p class="text-sm text-gray-600">{{ $interactionResults['clinical_significance'] }}</p>
                            </div>
                        @endif

                        <!-- Recommendations -->
                        @if(!empty($interactionResults['recommendations']))
                            <div class="mb-4">
                                <h5 class="text-sm font-medium text-gray-700 mb-2">Recommendations:</h5>
                                <p class="text-sm text-gray-600">{{ $interactionResults['recommendations'] }}</p>
                            </div>
                        @endif

                        <!-- Disclaimer -->
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                            <div class="flex">
                                <div class="flex-shrink-0">
                                    <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                                    </svg>
                                </div>
                                <div class="ml-3">
                                    <h3 class="text-sm font-medium text-yellow-800">Important Disclaimer</h3>
                                    <div class="mt-2 text-sm text-yellow-700">
                                        <p>This AI analysis is for informational purposes only and should not replace professional medical advice. Always consult with a qualified healthcare provider or pharmacist before making any medical decisions.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>