{{-- 
    EXAMPLE: Grouped Navigation Menu with Dropdowns
    This file demonstrates how to implement grouped navigation menus.
    Copy the relevant sections to your navigation.blade.php file.
--}}

@php
    use App\Services\NavigationService;
    $menuItems = NavigationService::getMenuItems();
@endphp

<!-- Navigation Links with Grouped Menus -->
<div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
    @foreach($menuItems as $item)
        @if($item['type'] === 'link')
            {{-- Single Link Item --}}
            <x-nav-link 
                :href="route($item['route'])" 
                :active="request()->routeIs($item['routePattern'])" 
                wire:navigate>
                {{ __($item['label']) }}
            </x-nav-link>
        
        @elseif($item['type'] === 'dropdown')
            {{-- Dropdown Menu Item --}}
            <x-dropdown align="left" width="48">
                <x-slot name="trigger">
                    <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 hover:text-gray-700 focus:outline-none transition ease-in-out duration-150 {{ App\Services\NavigationService::isDropdownActive($item['items']) ? 'text-gray-900 border-gray-300' : '' }}">
                        {{ __($item['label']) }}
                        <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </button>
                </x-slot>

                <x-slot name="content">
                    @foreach($item['items'] as $subItem)
                        <x-dropdown-link 
                            :href="route($subItem['route'])" 
                            wire:navigate
                            class="{{ request()->routeIs($subItem['routePattern']) ? 'bg-gray-100' : '' }}">
                            {{ __($subItem['label']) }}
                        </x-dropdown-link>
                    @endforeach
                </x-slot>
            </x-dropdown>
        @endif
    @endforeach
</div>

{{-- 
    ALTERNATIVE IMPLEMENTATION: Direct Implementation (No Service Class)
    This approach implements the grouped navigation directly in the Blade template.
--}}

{{-- 
<!-- Patient Care Dropdown -->
<x-dropdown align="left" width="48">
    <x-slot name="trigger">
        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
            Patient Care
            <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
    </x-slot>

    <x-slot name="content">
        @if(auth()->user()->canViewPatients())
            <x-dropdown-link :href="route('patients.index')" wire:navigate>
                {{ __('Patients') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isFrontDesk() || auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('visits.index')" wire:navigate>
                {{ __('Visits') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isDoctor() || auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('admissions.index')" wire:navigate>
                {{ __('Admissions') }}
            </x-dropdown-link>
        @endif
    </x-slot>
</x-dropdown>

<!-- Clinical Services Dropdown -->
<x-dropdown align="left" width="48">
    <x-slot name="trigger">
        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
            Clinical Services
            <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
    </x-slot>

    <x-slot name="content">
        @if(auth()->user()->isDoctor() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('doctor.consultations')" wire:navigate>
                {{ __('Consultations') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('nursing.vitals')" wire:navigate>
                {{ __('Nursing Station') }}
            </x-dropdown-link>
            <x-dropdown-link :href="route('medications.log')" wire:navigate>
                {{ __('Medication Log') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isDoctor() || auth()->user()->isLab() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('lab.workflow')" wire:navigate>
                {{ __('Lab') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isDoctor() || auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('surgeries.index')" wire:navigate>
                {{ __('Surgeries') }}
            </x-dropdown-link>
        @endif
    </x-slot>
</x-dropdown>
--}}

