<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class StaffUsersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create Nurse user
        User::create([
            'name' => 'Sarah Johnson',
            'email' => 'nurse@hospital.com',
            'password' => Hash::make('password'),
            'role' => 'nurse',
            'email_verified_at' => now(),
        ]);

        // Create Customer Service/Front Desk user
        User::create([
            'name' => 'Michael Chen',
            'email' => 'frontdesk@hospital.com',
            'password' => Hash::make('password'),
            'role' => 'front_desk',
            'email_verified_at' => now(),
        ]);

        $this->command->info('Staff users created successfully!');
        $this->command->info('Nurse: nurse@hospital.com / password');
        $this->command->info('Front Desk: frontdesk@hospital.com / password');
    }
}






















