<?php

namespace Database\Seeders;

use App\Models\DrugCategory;
use Illuminate\Database\Seeder;

class DrugCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'NSAID',
                'slug' => 'nsaid',
                'description' => 'Nonsteroidal anti-inflammatory drugs for pain and inflammation',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Antidiabetic',
                'slug' => 'antidiabetic',
                'description' => 'Medications for diabetes management',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'ACE Inhibitor',
                'slug' => 'ace-inhibitor',
                'description' => 'Angiotensin-converting enzyme inhibitors for hypertension and heart conditions',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Statin',
                'slug' => 'statin',
                'description' => 'Cholesterol-lowering medications',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Insulin',
                'slug' => 'insulin',
                'description' => 'Insulin preparations for diabetes management',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Anticoagulant',
                'slug' => 'anticoagulant',
                'description' => 'Blood thinners to prevent blood clots',
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Antibiotic',
                'slug' => 'antibiotic',
                'description' => 'Medications to treat bacterial infections',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'Analgesic',
                'slug' => 'analgesic',
                'description' => 'Pain relief medications',
                'is_active' => true,
                'sort_order' => 8,
            ],
            [
                'name' => 'Antihistamine',
                'slug' => 'antihistamine',
                'description' => 'Medications for allergies and allergic reactions',
                'is_active' => true,
                'sort_order' => 9,
            ],
            [
                'name' => 'Antacid',
                'slug' => 'antacid',
                'description' => 'Medications to neutralize stomach acid',
                'is_active' => true,
                'sort_order' => 10,
            ],
            [
                'name' => 'Vitamin',
                'slug' => 'vitamin',
                'description' => 'Vitamin and nutritional supplements',
                'is_active' => true,
                'sort_order' => 11,
            ],
            [
                'name' => 'Other',
                'slug' => 'other',
                'description' => 'Other medications and drugs',
                'is_active' => true,
                'sort_order' => 99,
            ],
        ];

        foreach ($categories as $category) {
            DrugCategory::updateOrCreate(
                ['slug' => $category['slug']],
                $category
            );
        }
    }
}
