<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('appointments', function (Blueprint $table) {
            // Make patient_id nullable to support guest/walk-in patients
            $table->foreignId('patient_id')->nullable()->change();
            
            // Add guest patient fields
            $table->string('guest_name')->nullable()->after('patient_id');
            $table->string('guest_phone')->nullable()->after('guest_name');
            $table->string('guest_email')->nullable()->after('guest_phone');
            
            // Add check-in timestamp
            $table->timestamp('checked_in_at')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('appointments', function (Blueprint $table) {
            // Remove guest fields
            $table->dropColumn(['guest_name', 'guest_phone', 'guest_email', 'checked_in_at']);
            
            // Make patient_id required again
            $table->foreignId('patient_id')->nullable(false)->change();
        });
    }
};
