<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pharmacy_stocks', function (Blueprint $table) {
            $table->foreignId('drug_id')->constrained()->onDelete('cascade')->after('id');
            $table->integer('quantity')->default(0)->after('drug_id');
            $table->integer('reorder_level')->default(10)->after('quantity');
            $table->decimal('unit_price', 10, 2)->nullable()->after('reorder_level');
            $table->date('expiry_date')->nullable()->after('unit_price');
            $table->string('batch_number')->nullable()->after('expiry_date');
            $table->string('supplier')->nullable()->after('batch_number');
            $table->date('supply_date')->nullable()->after('supplier');
            $table->text('notes')->nullable()->after('supply_date');
            
            // Indexes for performance
            $table->index('drug_id');
            $table->index('expiry_date');
            $table->index('quantity');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pharmacy_stocks', function (Blueprint $table) {
            $table->dropForeign(['drug_id']);
            $table->dropIndex(['drug_id']);
            $table->dropIndex(['expiry_date']);
            $table->dropIndex(['quantity']);
            $table->dropColumn([
                'drug_id',
                'quantity',
                'reorder_level',
                'unit_price',
                'expiry_date',
                'batch_number',
                'supplier',
                'supply_date',
                'notes',
            ]);
        });
    }
};
