<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignId('visit_id')->constrained()->onDelete('cascade');
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('requested_by')->constrained('users')->onDelete('cascade'); // Doctor who requested
            $table->string('test_type'); // e.g., 'blood_test', 'urine_test', 'xray', etc.
            $table->text('test_name'); // Specific test name
            $table->text('clinical_indication')->nullable(); // Why the test is needed
            $table->enum('status', ['pending', 'in_progress', 'completed', 'cancelled'])->default('pending');
            $table->foreignId('completed_by')->nullable()->constrained('users')->onDelete('set null'); // Lab staff
            $table->timestamp('requested_at')->useCurrent();
            $table->timestamp('completed_at')->nullable();
            $table->text('results')->nullable(); // Test results
            $table->json('result_data')->nullable(); // Structured result data
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->index('visit_id');
            $table->index('status');
            $table->index('requested_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_requests');
    }
};
