<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('visits', function (Blueprint $table) {
            $table->id();
            $table->string('visit_number')->unique(); // e.g., VIS-2025-001234
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade'); // Receptionist who checked in
            $table->enum('status', [
                'checked_in',           // Reception - patient checked in
                'waiting_nurse',        // Waiting for nursing station
                'waiting_doctor',       // Vitals taken, waiting for doctor
                'in_consultation',      // Doctor is seeing patient
                'lab_requested',        // Lab tests requested
                'prescription_issued',   // Prescription given
                'pharmacy_dispensed',    // Pharmacy has dispensed medications
                'billing_pending',      // Waiting for billing
                'checked_out'           // Visit completed
            ])->default('checked_in');
            $table->timestamp('checked_in_at');
            $table->timestamp('checked_out_at')->nullable();
            $table->text('chief_complaint')->nullable(); // Initial complaint at check-in
            $table->text('visit_notes')->nullable(); // General visit notes
            $table->timestamps();
            
            // Indexes for performance
            $table->index('patient_id');
            $table->index('status');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('visits');
    }
};
