<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admissions', function (Blueprint $table) {
            $table->id();
            $table->string('admission_number')->unique(); // e.g., ADM-2025-001234
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('visit_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('admitted_by')->constrained('users')->onDelete('cascade'); // Doctor who admitted
            $table->foreignId('discharged_by')->nullable()->constrained('users')->onDelete('set null');
            $table->string('ward')->nullable(); // e.g., "General Ward", "ICU", "Pediatrics"
            $table->string('room_number')->nullable();
            $table->string('bed_number')->nullable();
            $table->text('admission_reason'); // Why patient is being admitted
            $table->text('diagnosis')->nullable();
            $table->text('admission_notes')->nullable();
            $table->enum('status', ['admitted', 'discharged', 'transferred'])->default('admitted');
            $table->timestamp('admission_date');
            $table->timestamp('discharge_date')->nullable();
            $table->text('discharge_notes')->nullable();
            $table->text('discharge_instructions')->nullable();
            $table->timestamps();
            
            // Indexes for performance
            $table->index('patient_id');
            $table->index('visit_id');
            $table->index('status');
            $table->index('admission_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admissions');
    }
};
