<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Auth\Access\AuthorizationException;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Register custom middleware aliases
        $middleware->alias([
            'role' => \App\Http\Middleware\EnsureRole::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        // Handle authentication exceptions - redirect to login
        $exceptions->render(function (AuthenticationException $e, $request) {
            if ($request->expectsJson() || $request->is('livewire/*')) {
                return response()->json(['message' => 'Unauthenticated', 'redirect' => route('login')], 401);
            }
            return redirect()->guest(route('login'));
        });

        // Handle authorization exceptions for unauthenticated users
        $exceptions->render(function (AuthorizationException $e, $request) {
            if (!auth()->check()) {
                if ($request->expectsJson() || $request->is('livewire/*')) {
                    return response()->json(['message' => 'Session expired. Please login again.', 'redirect' => route('login')], 401);
                }
                return redirect()->guest(route('login'))->with('error', 'Your session has expired. Please login again.');
            }
        });
    })->create();
