<?php

namespace App\Services;

use Illuminate\Support\Facades\Crypt;

class EncryptionService
{
    /**
     * Encrypt sensitive data (PHI)
     */
    public static function encrypt(string $value): string
    {
        if (empty($value)) {
            return $value;
        }
        return Crypt::encryptString($value);
    }

    /**
     * Decrypt sensitive data (PHI)
     */
    public static function decrypt(string $encryptedValue): string
    {
        if (empty($encryptedValue)) {
            return $encryptedValue;
        }
        try {
            return Crypt::decryptString($encryptedValue);
        } catch (\Exception $e) {
            // If decryption fails, assume it's already plain text (for migration)
            return $encryptedValue;
        }
    }

    /**
     * Check if value is encrypted
     */
    public static function isEncrypted(string $value): bool
    {
        // Encrypted values typically start with base64 encoded data
        // Laravel's encrypted strings have a specific format
        return !empty($value) && base64_decode($value, true) !== false && strlen($value) > 50;
    }
}


