<?php

namespace App\Providers;

use App\Models\MedicalRecord;
use App\Models\Patient;
use App\Models\Visit;
use App\Policies\MedicalRecordPolicy;
use App\Policies\PatientPolicy;
use App\Policies\VisitPolicy;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Patient::class => PatientPolicy::class,
        Visit::class => VisitPolicy::class,
        MedicalRecord::class => MedicalRecordPolicy::class,
    ];

    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register policies
        foreach ($this->policies as $model => $policy) {
            Gate::policy($model, $policy);
        }

        // Define additional gates for role-based access
        Gate::define('manage-visits', function ($user) {
            return $user->isFrontDesk() || $user->isDoctor();
        });

        Gate::define('access-nursing', function ($user) {
            return $user->isNurse();
        });

        Gate::define('access-lab', function ($user) {
            return $user->isDoctor() || $user->isLab();
        });

        Gate::define('access-pharmacy', function ($user) {
            return $user->isDoctor() || $user->isPharmacy();
        });
    }
}
