<?php

namespace App\Policies;

use App\Models\Patient;
use App\Models\User;

class PatientPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        // All authenticated users can view patients
        return true;
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Patient $patient): bool
    {
        // All authenticated users can view patient details
        return true;
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        // Only front desk, developer, and cmd can create patients (doctors cannot)
        return $user->canManagePatients();
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Patient $patient): bool
    {
        // Only doctors and front desk can update patients
        return $user->canManagePatients();
    }

    /**
     * Determine whether the user can update medical history/allergies.
     */
    public function updateMedicalHistory(User $user, Patient $patient): bool
    {
        // Only nurses and doctors can update medical history/allergies
        return $user->isNurse() || $user->isDoctor();
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Patient $patient): bool
    {
        // Only doctors can delete patients
        return $user->isDoctor();
    }
}
