<?php

namespace App\Policies;

use App\Models\MedicalRecord;
use App\Models\User;

class MedicalRecordPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        // Doctors and nurses can view medical records
        return $user->isDoctor() || $user->isNurse();
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, MedicalRecord $medicalRecord): bool
    {
        // Doctors and nurses can view medical records
        return $user->isDoctor() || $user->isNurse();
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        // Only doctors and nurses can create medical records
        return $user->isDoctor() || $user->isNurse();
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, MedicalRecord $medicalRecord): bool
    {
        // Only doctors can update medical records
        // Nurses can only create/update vitals during visit
        return $user->isDoctor() || ($user->isNurse() && $medicalRecord->visit_id);
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, MedicalRecord $medicalRecord): bool
    {
        // Only doctors can delete medical records
        return $user->isDoctor();
    }
}
