<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @param  string  ...$roles
     */
    public function handle(Request $request, Closure $next, string ...$roles): Response
    {
        if (!auth()->check()) {
            if ($request->expectsJson() || $request->is('livewire/*')) {
                return response()->json(['message' => 'Session expired. Please login again.', 'redirect' => route('login')], 401);
            }
            return redirect()->guest(route('login'))->with('error', 'Your session has expired. Please login again.');
        }

        $user = auth()->user();
        
        // Check if user has any of the required roles
        $hasRole = false;
        foreach ($roles as $role) {
            if ($user->hasRole($role) || 
                ($role === 'doctor' && $user->isDoctor()) ||
                ($role === 'nurse' && $user->isNurse()) ||
                ($role === 'front_desk' && $user->isFrontDesk()) ||
                ($role === 'pharmacy' && $user->isPharmacy()) ||
                ($role === 'billing' && $user->isBilling()) ||
                ($role === 'lab' && $user->isLab()) ||
                ($role === 'staff' && $user->isStaff()) ||
                ($role === 'developer' && $user->isDeveloper()) ||
                ($role === 'cmd' && $user->isCmd())) {
                $hasRole = true;
                break;
            }
        }

        if (!$hasRole) {
            abort(403, 'Access denied. Insufficient permissions.');
        }

        return $next($request);
    }
}
