{{--
    SIMPLE EXAMPLE: How to Implement Grouped Navigation Menus
    
    This file shows a simple, direct implementation of grouped navigation menus.
    Copy and adapt these examples to your navigation.blade.php file.
--}}

<!-- Example 1: Patient Care Dropdown Category -->
<x-dropdown align="left" width="48">
    <x-slot name="trigger">
        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
            {{ __('Patient Care') }}
            <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
    </x-slot>

    <x-slot name="content">
        @if(auth()->user()->canViewPatients())
            <x-dropdown-link :href="route('patients.index')" wire:navigate>
                {{ __('Patients') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isFrontDesk() || auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('visits.index')" wire:navigate>
                {{ __('Visits') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isDoctor() || auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('admissions.index')" wire:navigate>
                {{ __('Admissions') }}
            </x-dropdown-link>
        @endif
    </x-slot>
</x-dropdown>

<!-- Example 2: Clinical Services Dropdown Category -->
<x-dropdown align="left" width="48">
    <x-slot name="trigger">
        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
            {{ __('Clinical Services') }}
            <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
    </x-slot>

    <x-slot name="content">
        @if(auth()->user()->isDoctor() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('doctor.consultations')" wire:navigate>
                {{ __('Consultations') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('nursing.vitals')" wire:navigate>
                {{ __('Nursing Station') }}
            </x-dropdown-link>
            <x-dropdown-link :href="route('medications.log')" wire:navigate>
                {{ __('Medication Log') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isDoctor() || auth()->user()->isLab() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('lab.workflow')" wire:navigate>
                {{ __('Lab') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->isDoctor() || auth()->user()->isNurse() || auth()->user()->isDeveloper() || auth()->user()->isCmd())
            <x-dropdown-link :href="route('surgeries.index')" wire:navigate>
                {{ __('Surgeries') }}
            </x-dropdown-link>
        @endif
    </x-slot>
</x-dropdown>

<!-- Example 3: Pharmacy & Billing Dropdown Category -->
<x-dropdown align="left" width="48">
    <x-slot name="trigger">
        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 hover:text-gray-700 focus:outline-none transition ease-in-out duration-150">
            {{ __('Pharmacy & Billing') }}
            <svg class="ms-2 -me-0.5 h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
            </svg>
        </button>
    </x-slot>

    <x-slot name="content">
        @if(auth()->user()->canViewPrescriptions())
            <x-dropdown-link :href="route('prescriptions.index')" wire:navigate>
                {{ __('Prescriptions') }}
            </x-dropdown-link>
        @endif
        
        @if(auth()->user()->canViewBills())
            @if(auth()->user()->canManageBills())
                <x-dropdown-link :href="route('billing.visits')" wire:navigate>
                    {{ __('Billing') }}
                </x-dropdown-link>
            @else
                <x-dropdown-link :href="route('bills.index')" wire:navigate>
                    {{ __('Billing') }}
                </x-dropdown-link>
            @endif
        @endif
    </x-slot>
</x-dropdown>

{{--
    KEY POINTS:
    
    1. Use <x-dropdown> component for menu categories
    2. Use <x-slot name="trigger"> for the dropdown button
    3. Use <x-slot name="content"> for dropdown menu items
    4. Use <x-dropdown-link> for each menu item in the dropdown
    5. Use wire:navigate for Livewire navigation
    6. Use @if conditions to show/hide items based on user permissions
    7. The dropdown automatically handles open/close with Alpine.js
    
    STYLING NOTES:
    - align="left" positions dropdown to the left
    - width="48" sets dropdown width (w-48 = 12rem)
    - SVG icon shows dropdown indicator (chevron down)
    - Button styling matches your existing nav-link styling
--}}




