# Inventory Management System Guide

## Overview
The Inventory Management system tracks pharmacy stock levels, prices, expiry dates, and supplier information for all drugs in the system.

## Key Features

### 1. Stock Entry Management
- Create, edit, and delete stock entries
- Each entry links to a specific drug
- Track multiple stock entries per drug (different batches, suppliers, etc.)

### 2. Stock Tracking Fields
- **Drug**: Links to drug catalog (required)
- **Quantity**: Current stock level (required)
- **Reorder Level**: Minimum stock before reordering (default: 10)
- **Unit Price**: Price per unit (used in billing)
- **Expiry Date**: When stock expires (optional)
- **Batch Number**: Batch/lot number (optional)
- **Supplier**: Supplier name (optional)
- **Supply Date**: When stock was received (optional)
- **Notes**: Additional information (optional)

### 3. Stock Status Indicators
- **In Stock**: Normal stock level
- **Low Stock**: Quantity ≤ reorder level (highlighted in orange)
- **Expiring Soon**: Expires within 30 days (highlighted in yellow)
- **Expired**: Past expiry date (highlighted in red)

### 4. Filtering & Search
- Search by drug name or generic name
- Filter by status: All, Low Stock, Expiring Soon, Expired

### 5. Bulk Upload
- Upload CSV file with multiple inventory entries
- Requires drug to exist in catalog first
- Format: drug_name, quantity, reorder_level, unit_price, expiry_date, batch_number, supplier, supply_date, notes

## Workflow

### Adding Stock
1. Click "+ Add Stock Entry"
2. Select drug from dropdown (only active drugs shown)
3. Enter quantity and other details
4. Set unit price (used for prescription billing)
5. Save entry

### Monitoring Stock
- View all stock entries in table format
- Low stock items highlighted in red
- Expiring items highlighted in yellow
- Expired items highlighted in red with red background

### Billing Integration
- Unit prices from pharmacy_stocks are used in prescription billing
- System retrieves latest stock entry with price for each prescription drug
- Falls back to prescription service fee if no price found

## Database Structure

### pharmacy_stocks table
- drug_id (foreign key to drugs table)
- quantity (integer)
- reorder_level (integer)
- unit_price (decimal)
- expiry_date (date)
- batch_number (string)
- supplier (string)
- supply_date (date)
- notes (text)

### Relationships
- Each stock entry belongs to one drug
- Each drug can have multiple stock entries (different batches/suppliers)
- Stock entries are used to calculate prescription prices in billing

## Access Control
- Only pharmacy staff, developers, and CMD can access inventory management
- Standard role-based access control applies
