# Drug Management Actions Explained

## Deactivate / Activate

**What it does:**
- Changes the `is_active` status of a drug
- Deactivate: Sets `is_active = false`
- Activate: Sets `is_active = true`

**Effect:**
- Deactivated drugs are hidden from certain dropdowns/selections
- The drug record remains in the database
- All associated data (prescriptions, stock entries) are preserved
- Can be reactivated later if needed

**Use cases:**
- Temporarily hide a drug from selection (e.g., discontinued, temporarily unavailable)
- Keep historical data intact while preventing new prescriptions
- Maintain audit trail

## Delete

**What it does:**
- Permanently removes the drug record from the database
- Checks if the drug is used in any prescriptions before deletion
- If used in prescriptions: Deletion is blocked with an error message
- If not used: Drug is permanently deleted

**Restrictions:**
- Cannot delete drugs that have been used in prescriptions
- This prevents breaking historical prescription records

**Effect:**
- Drug record is completely removed
- Cannot be recovered
- Stock entries may become orphaned (depending on database constraints)
- Historical prescriptions may lose drug reference (if cascade delete is enabled)

**Use cases:**
- Remove incorrectly entered drugs (before any prescriptions are created)
- Clean up test/duplicate entries
- Remove drugs that were never actually used

## Recommendation

- Use **Deactivate** for drugs that may be needed again or have historical data
- Use **Delete** only for incorrectly entered drugs that were never used
- Prefer Deactivate over Delete to maintain data integrity
